/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue.quickfix;

import com.intellij.build.SyncViewManager;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.issue.quickfix.ReimportQuickFix;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleWrapperSettingsOpenQuickFix;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleVersionQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "projectPath", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "requestImport", "", "(Ljava/lang/String;Lorg/gradle/util/GradleVersion;Z)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "runWrapperTask", "", "updateOrCreateWrapper", "Companion", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class GradleVersionQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final String id;
    private final String projectPath;
    private final GradleVersion gradleVersion;
    private final boolean requestImport;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.updateOrCreateWrapper().exceptionally(new Function(project){
            final /* synthetic */ Project $project;

            public final Void apply(Throwable it) {
                GradleVersionQuickFix.access$getLOG$cp().warn(it);
                String msg = "Unable to update wrapper files";
                NotificationData notificationData = new NotificationData(msg, "See IDE log for the details.\n<a href=\"#open_log\">" + ShowLogAction.getActionName() + "</a>", NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
                boolean bl = false;
                boolean bl2 = false;
                NotificationData $this$apply = notificationData;
                boolean bl3 = false;
                $this$apply.setBalloonNotification(true);
                $this$apply.setBalloonGroup("Gradle Import");
                $this$apply.setListener("#open_log", (NotificationListener)runQuickFix.notification.1.1.INSTANCE);
                NotificationData notification2 = notificationData;
                ExternalSystemNotificationManager.getInstance((Project)this.$project).showNotification(GradleConstants.SYSTEM_ID, notification2);
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                throw throwable;
            }
            {
                this.$project = project;
            }
        })).thenApply(new Function<Object, Unit>(this, project){
            final /* synthetic */ GradleVersionQuickFix this$0;
            final /* synthetic */ Project $project;

            public final void apply(Object it) {
                ExternalProjectSettings externalProjectSettings = GradleSettings.getInstance(this.$project).getLinkedProjectSettings(GradleVersionQuickFix.access$getProjectPath$p(this.this$0));
                Intrinsics.checkNotNull((Object)externalProjectSettings);
                Intrinsics.checkNotNullExpressionValue((Object)externalProjectSettings, (String)"GradleSettings.getInstan\u2026ctSettings(projectPath)!!");
                ((GradleProjectSettings)externalProjectSettings).setDistributionType(DistributionType.DEFAULT_WRAPPED);
            }
            {
                this.this$0 = gradleVersionQuickFix;
                this.$project = project;
            }
        })).thenComposeAsync(new Function<Unit, CompletionStage>(this, project){
            final /* synthetic */ GradleVersionQuickFix this$0;
            final /* synthetic */ Project $project;

            public final CompletionStage apply(Unit it) {
                return GradleVersionQuickFix.access$runWrapperTask(this.this$0, this.$project);
            }
            {
                this.this$0 = gradleVersionQuickFix;
                this.$project = project;
            }
        })).thenApply(new Function(this, project){
            final /* synthetic */ GradleVersionQuickFix this$0;
            final /* synthetic */ Project $project;

            public final void apply(Void it) {
                GradleWrapperSettingsOpenQuickFix.Companion.showWrapperPropertiesFile(this.$project, GradleVersionQuickFix.access$getProjectPath$p(this.this$0), GradleVersionQuickFix.access$getGradleVersion$p(this.this$0).getVersion());
            }
            {
                this.this$0 = gradleVersionQuickFix;
                this.$project = project;
            }
        })).thenComposeAsync(new Function<Unit, CompletionStage>(this, project){
            final /* synthetic */ GradleVersionQuickFix this$0;
            final /* synthetic */ Project $project;

            public final CompletionStage apply(Unit it) {
                if (GradleVersionQuickFix.access$getRequestImport$p(this.this$0)) {
                    TimeoutUtil.sleep((long)500L);
                    String string = GradleVersionQuickFix.access$getProjectPath$p(this.this$0);
                    ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
                    Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"GradleConstants.SYSTEM_ID");
                    return ReimportQuickFix.Companion.requestImport(this.$project, string, projectSystemId);
                }
                return CompletableFuture.completedFuture(null);
            }
            {
                this.this$0 = gradleVersionQuickFix;
                this.$project = project;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"updateOrCreateWrapper()\n\u2026e(null)\n        }\n      }");
        return completionStage;
    }

    private final CompletableFuture<?> updateOrCreateWrapper() {
        CompletableFuture completableFuture = CompletableFuture.supplyAsync((Supplier)new Supplier<Unit>(this){
            final /* synthetic */ GradleVersionQuickFix this$0;

            public final void get() {
                Properties wrapperProperties = null;
                File wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(GradleVersionQuickFix.access$getProjectPath$p(this.this$0));
                String distributionUrl = "https://services.gradle.org/distributions/gradle-" + GradleVersionQuickFix.access$getGradleVersion$p(this.this$0).getVersion() + "-bin.zip";
                if (wrapperPropertiesFile == null) {
                    Path wrapperPropertiesPath;
                    Path path = wrapperPropertiesPath = Paths.get(GradleVersionQuickFix.access$getProjectPath$p(this.this$0), "gradle", "wrapper", "gradle-wrapper.properties");
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"wrapperPropertiesPath");
                    PathKt.createFile((Path)path);
                    wrapperPropertiesFile = wrapperPropertiesPath.toFile();
                    wrapperProperties = new Properties();
                    ((Map)wrapperProperties).put("distributionUrl", distributionUrl);
                    ((Map)wrapperProperties).put("distributionBase", "GRADLE_USER_HOME");
                    ((Map)wrapperProperties).put("distributionPath", "wrapper/dists");
                    ((Map)wrapperProperties).put("zipStoreBase", "GRADLE_USER_HOME");
                    ((Map)wrapperProperties).put("zipStorePath", "wrapper/dists");
                } else {
                    Properties properties = GUtil.loadProperties((File)wrapperPropertiesFile);
                    Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"GUtil.loadProperties(wrapperPropertiesFile)");
                    wrapperProperties = properties;
                    ((Map)wrapperProperties).put("distributionUrl", distributionUrl);
                }
                PropertiesUtils.store((Properties)wrapperProperties, (File)wrapperPropertiesFile);
                LocalFileSystem.getInstance().refreshIoFiles((Iterable)CollectionsKt.listOf((Object)wrapperPropertiesFile));
            }
            {
                this.this$0 = gradleVersionQuickFix;
            }
        });
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.supply\u2026perPropertiesFile))\n    }");
        return completableFuture;
    }

    private final CompletableFuture runWrapperTask(Project project) {
        UserDataHolderBase userData = new UserDataHolderBase();
        String initScript = "gradle.projectsEvaluated { g ->\n  def wrapper = g.rootProject.tasks.wrapper\n  if (wrapper == null) return \n  wrapper.gradleVersion = '" + this.gradleVersion.getVersion() + "'\n" + "}\n";
        userData.putUserData(GradleTaskManager.INIT_SCRIPT_KEY, (Object)initScript);
        userData.putUserData(ExternalSystemRunConfiguration.PROGRESS_LISTENER_KEY, SyncViewManager.class);
        GradleSettings gradleSettings = GradleSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"GradleSettings.getInstance(project)");
        String gradleVmOptions = gradleSettings.getGradleVmOptions();
        ExternalSystemTaskExecutionSettings settings2 = new ExternalSystemTaskExecutionSettings();
        settings2.setExecutionName(GradleBundle.message("grable.execution.name.upgrade.wrapper", new Object[0]));
        settings2.setExternalProjectPath(this.projectPath);
        settings2.setTaskNames(CollectionsKt.listOf((Object)"wrapper"));
        settings2.setVmOptions(gradleVmOptions);
        ProjectSystemId projectSystemId = GradleConstants.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"GradleConstants.SYSTEM_ID");
        settings2.setExternalSystemIdString(projectSystemId.getId());
        CompletableFuture future = new CompletableFuture();
        ExternalSystemUtil.runTask((ExternalSystemTaskExecutionSettings)settings2, (String)"Run", (Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (TaskCallback)new TaskCallback(future){
            final /* synthetic */ CompletableFuture $future;

            public void onSuccess() {
                this.$future.complete(null);
            }

            public void onFailure() {
                this.$future.completeExceptionally(new RuntimeException("Wrapper task failed"));
            }
            {
                this.$future = $captured_local_variable$0;
            }
        }, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC, (boolean)false, (UserDataHolderBase)userData);
        return future;
    }

    public GradleVersionQuickFix(@NotNull String projectPath, @NotNull GradleVersion gradleVersion, boolean requestImport) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        this.projectPath = projectPath;
        this.gradleVersion = gradleVersion;
        this.requestImport = requestImport;
        this.id = "fix_gradle_version_in_wrapper";
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleVersionQuickFix.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ String access$getProjectPath$p(GradleVersionQuickFix $this) {
        return $this.projectPath;
    }

    public static final /* synthetic */ CompletableFuture access$runWrapperTask(GradleVersionQuickFix $this, Project project) {
        return $this.runWrapperTask(project);
    }

    public static final /* synthetic */ GradleVersion access$getGradleVersion$p(GradleVersionQuickFix $this) {
        return $this.gradleVersion;
    }

    public static final /* synthetic */ boolean access$getRequestImport$p(GradleVersionQuickFix $this) {
        return $this.requestImport;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/issue/quickfix/GradleVersionQuickFix$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gradle.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

