/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.ngrams.ConfusionProbabilityRule;

public class EnglishConfusionProbabilityRule
extends ConfusionProbabilityRule {
    private static final List<String> EXCEPTIONS = Arrays.asList("your slack profile", "host to five", "had I known", "is not exactly known", "live duet", "isn't known", "your move makes", "your move is", "he unchecked the", "thank you for the patience", "your patience regarding", "your fix", "your commit", "on point", "chapter one", "usb port", "know the competition and", "know the competition or", "know your competition and", "know your competition or", "G Suite", "paste event", "need to know", "of you not", "of her element", "very grateful of you", "your use case", "he's", "he\u2019s", "they're", "they\u2019re", "your look is", "have you known", "have I known", "had I known", "had you known", "his fluffy butt", "it's now better", "it\u2019s now better", "it is now better", "let us know below", "let us know in", "your kind of", "sneak peek", "the 4 of you", "your ride", "he most likely", "good cause", "big butt", "news debate", "verify you own", "ensure you own", "happy us!", "your pick up", "no but you", "no but we", "no but he", "no but I", "no but they", "no but she", "no but it", "he tracks", "which complains about", "do your work", "one many times", "let us know", "let me know", "this way the", "save you money", "way better", "so your plan", "the news man", "created us equally", ", their,", ", your,", ", its,", "us, humans,", "bring you happiness", "in a while", "confirm you own", "oh, god", "honey nut", "not now", "he proofs", "he needs", "1 thing", "way easier", "way faster", "way harder", "way quicker", "way more", "way less", "way outside", "way before", "way smaller", "way bigger", "way longer", "way shorter", "I now don't", "once your return is", "can we text", "believe in god", "on premise", "from poor to rich", "my GPU", "was your everything", "they mustnt", "reply my email", "things god said", "let you text", "doubt in god", "in the news", "(news)", "fresh prince of", "good day bye", "it's us", "could be us being", "on twitter", "enjoy us being", "If your use of", "way too", "then,", "then?", "no it doesn", "no it isn", "no it wasn", "no it hasn", "no it can't", "no it won't", "no it wouldn", "no it couldn", "no it shouldn", "no that's not", "provided my country", "no i don't", "no i can't", "no i won't", "no i wasn", "no i haven", "no i wouldn", "no i couldn", "no i shouldn", "no you don't", "no you can't", "no you won't", "no you weren", "no you haven", "no you wouldn", "no you couldn", "no you shouldn", "no they were not", "no there was no", "no there was not", "no there wasn", "no there is no", "no there is not", "no there isn", "no there are no", "no there are not", "no there aren", "no there were no", "no there were not", "no there weren", "no this is not", "no that is not", "no we were not", "no all good", "no everything alright", "no everything good", "no everything fine", "no we don't", "for your recharge", "all you kids", "thanks for the patience", "what to text", "is he famous for", "was he famous for", "really quiet at", "he programs", "scene 1", "scene 2", "scene 3", "scene 4", "scene 5", "scene 6", "scene 7", "scene 8", "scene 9", "scene 10", "scene 11", "scene 12", "scene 13", "scene 14", "scene 15", "make a hire", "on the news", "brown plane", "news politics", "organic reach", "out bid", "message us in", "I picture us", "your and our", "house and pool", "your set up is", "your set up was", "because your pay is", "but your pay is", "the while block", "updated my edge", "he haven", "is he naked", "these news sound", "those news sound", "(t)he", "[t]he", "the role at", "same false alarm", "why is he relevant", "why is he famous", "then that would", "was he part of", "is he right now", "news page", "news pages", "news headline", "news headlines", "news title", "news titles", "news site", "news sites", "news website", "news websites", "news channel", "news channels", "news organization", "news organizations", "news organisation", "news organisations", "scene in a movie", "mr.bean", "mr. bean", "your push notification", "check our page about", "have a think", "had a think", "live support", "your troll", "waist type", "(wait)", "now ahead of schedule", "tag us in", "your rebuild", "got to know new", "to live post", "sea pineapple", "the commit", "appreciate you contacting me", "appreciate you contacting us", "appreciate you informing me", "appreciate you informing us", "appreciate you confirming it", "appreciate you confirming this", "appreciate you confirming that", "appreciate you choosing us", "appreciate you choosing me", "wand wood", "my order", "of you being her");

    public EnglishConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language) {
        this(messages, languageModel, language, 3);
    }

    public EnglishConfusionProbabilityRule(ResourceBundle messages, LanguageModel languageModel, Language language, int grams) {
        super(messages, languageModel, language, grams, EXCEPTIONS);
        this.addExamplePair(Example.wrong((String)"I did not <marker>now</marker> where it came from."), Example.fixed((String)"I did not <marker>know</marker> where it came from."));
    }

    protected boolean isException(String sentence, int startPos, int endPos) {
        String covered;
        return startPos > 3 && (covered = sentence.substring(startPos - 3, endPos)).matches("['\u2019`\u00b4\u2018]t .*");
    }
}

