/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import org.gradle.internal.impldep.org.simpleframework.http.Request;
import org.gradle.internal.impldep.org.simpleframework.http.Response;
import org.gradle.internal.impldep.org.simpleframework.http.core.Channel;
import org.gradle.internal.impldep.org.simpleframework.http.core.Container;
import org.gradle.internal.impldep.org.simpleframework.http.core.Entity;
import org.gradle.internal.impldep.org.simpleframework.http.core.FlushMonitor;
import org.gradle.internal.impldep.org.simpleframework.http.core.Initiator;
import org.gradle.internal.impldep.org.simpleframework.http.core.Monitor;
import org.gradle.internal.impldep.org.simpleframework.http.core.RequestEntity;
import org.gradle.internal.impldep.org.simpleframework.http.core.ResponseEntity;

class Dispatcher
implements Runnable {
    private final Container container;
    private final Response response;
    private final Request request;
    private final Monitor monitor;
    private final Entity entity;

    public Dispatcher(Container container, Initiator reactor, Entity entity) {
        this.monitor = new FlushMonitor(reactor, entity);
        this.request = new RequestEntity(entity, this.monitor);
        this.response = new ResponseEntity(this.request, entity, this.monitor);
        this.container = container;
        this.entity = entity;
    }

    public void run() {
        try {
            this.dispatch();
        }
        catch (Exception e) {
            return;
        }
    }

    private void dispatch() throws Exception {
        Channel channel = this.entity.getChannel();
        try {
            this.container.handle(this.request, this.response);
        }
        catch (Throwable e) {
            channel.close();
        }
    }
}

