/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import org.gradle.internal.impldep.org.simpleframework.http.Request;
import org.gradle.internal.impldep.org.simpleframework.http.Response;

class Conversation {
    private final Response response;
    private final Request request;

    public Conversation(Request request, Response response) {
        this.response = response;
        this.request = request;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public int getContentLength() {
        return this.response.getContentLength();
    }

    public boolean isEmpty() {
        int code = this.response.getCode();
        if (code == 204) {
            return true;
        }
        return code == 304;
    }

    public boolean isHead() {
        String method = this.request.getMethod();
        if (method == null) {
            return false;
        }
        return method.equalsIgnoreCase("HEAD");
    }

    public void setContentLength(int length) {
        boolean keepAlive = this.isKeepAlive();
        if (keepAlive) {
            this.response.set("Connection", "keep-alive");
        } else {
            this.response.set("Connection", "close");
        }
        this.response.set("Content-Length", length);
    }

    public boolean isPersistent() {
        String token = this.request.getValue("Connection");
        if (token != null) {
            return token.equalsIgnoreCase("keep-alive");
        }
        int major = this.request.getMajor();
        int minor = this.request.getMinor();
        if (major >= 1) {
            return minor >= 1;
        }
        return false;
    }

    public boolean isKeepAlive() {
        String token = this.response.getValue("Connection");
        if (token != null) {
            return token.equalsIgnoreCase("keep-alive");
        }
        return this.isPersistent();
    }

    public boolean isChunkable() {
        int major = this.request.getMajor();
        int minor = this.request.getMinor();
        if (major >= 1) {
            return minor >= 1;
        }
        return false;
    }

    public void setChunkedEncoded() {
        boolean keepAlive = this.isKeepAlive();
        boolean chunkable = this.isChunkable();
        if (keepAlive && chunkable) {
            this.response.set("Transfer-Encoding", "chunked");
            this.response.set("Connection", "keep-alive");
        } else {
            this.response.set("Connection", "close");
        }
    }

    public void setIdentityEncoded() {
        this.response.remove("Transfer-Encoding");
    }

    public boolean isChunkedEncoded() {
        String token = this.response.getValue("Transfer-Encoding");
        if (token != null) {
            return token.equalsIgnoreCase("chunked");
        }
        return false;
    }
}

