/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file;

import java.lang.ref.SoftReference;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.file.PackFile;
import org.gradle.internal.impldep.org.eclipse.jgit.storage.file.WindowCacheConfig;

class DeltaBaseCache {
    private static final int CACHE_SZ = 1024;
    static final SoftReference<Entry> DEAD = new SoftReference<Object>(null);
    private static volatile int defaultMaxByteCount;
    private final int maxByteCount = defaultMaxByteCount;
    private final Slot[] cache = new Slot[1024];
    private Slot lruHead;
    private Slot lruTail;
    private int openByteCount;

    static {
        DeltaBaseCache.reconfigure(new WindowCacheConfig());
    }

    private static int hash(long position) {
        return (int)position << 22 >>> 22;
    }

    static void reconfigure(WindowCacheConfig cfg) {
        defaultMaxByteCount = cfg.getDeltaBaseCacheLimit();
    }

    DeltaBaseCache() {
    }

    Entry get(PackFile pack, long position) {
        Entry buf;
        Slot e = this.cache[DeltaBaseCache.hash(position)];
        if (e == null) {
            return null;
        }
        if (e.provider == pack && e.position == position && (buf = e.data.get()) != null) {
            this.moveToHead(e);
            return buf;
        }
        return null;
    }

    void store(PackFile pack, long position, byte[] data, int objectType) {
        if (data.length > this.maxByteCount) {
            return;
        }
        Slot e = this.cache[DeltaBaseCache.hash(position)];
        if (e == null) {
            this.cache[DeltaBaseCache.hash((long)position)] = e = new Slot();
        } else {
            this.clearEntry(e);
        }
        this.openByteCount += data.length;
        this.releaseMemory();
        e.provider = pack;
        e.position = position;
        e.sz = data.length;
        e.data = new SoftReference<Entry>(new Entry(data, objectType));
        this.moveToHead(e);
    }

    private void releaseMemory() {
        while (this.openByteCount > this.maxByteCount && this.lruTail != null) {
            Slot currOldest = this.lruTail;
            Slot nextOldest = currOldest.lruPrev;
            this.clearEntry(currOldest);
            currOldest.lruPrev = null;
            currOldest.lruNext = null;
            if (nextOldest == null) {
                this.lruHead = null;
            } else {
                nextOldest.lruNext = null;
            }
            this.lruTail = nextOldest;
        }
    }

    private void moveToHead(Slot e) {
        this.unlink(e);
        e.lruPrev = null;
        e.lruNext = this.lruHead;
        if (this.lruHead != null) {
            this.lruHead.lruPrev = e;
        } else {
            this.lruTail = e;
        }
        this.lruHead = e;
    }

    private void unlink(Slot e) {
        Slot prev = e.lruPrev;
        Slot next = e.lruNext;
        if (prev != null) {
            prev.lruNext = next;
        }
        if (next != null) {
            next.lruPrev = prev;
        }
    }

    private void clearEntry(Slot e) {
        this.openByteCount -= e.sz;
        e.provider = null;
        e.data = DEAD;
        e.sz = 0;
    }

    static class Entry {
        final byte[] data;
        final int type;

        Entry(byte[] aData, int aType) {
            this.data = aData;
            this.type = aType;
        }
    }

    private static class Slot {
        Slot lruPrev;
        Slot lruNext;
        PackFile provider;
        long position;
        int sz;
        SoftReference<Entry> data = DEAD;

        private Slot() {
        }
    }
}

