/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters;

import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.util.StringUtils;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    private static final String IMPLEMENTATION = "implementation";

    protected Class getClassForImplementationHint(Class type, PlexusConfiguration configuration, ClassLoader classLoader) throws ComponentConfigurationException {
        Class<?> retValue = type;
        String implementation = configuration.getAttribute(IMPLEMENTATION, null);
        if (implementation != null) {
            try {
                retValue = classLoader.loadClass(implementation);
            }
            catch (ClassNotFoundException e) {
                String msg = "ClassNotFoundException: Class name which was explicitly given in configuration using 'implementation' attribute: '" + implementation + "' cannot be loaded";
                throw new ComponentConfigurationException(msg, (Throwable)e);
            }
            catch (UnsupportedClassVersionError e) {
                String msg = "UnsupportedClassVersionError: Class name which was explicitly given in configuration using 'implementation' attribute: '" + implementation + "' cannot be loaded";
                throw new ComponentConfigurationException(msg, (Throwable)e);
            }
            catch (LinkageError e) {
                String msg = "LinkageError: Class name which was explicitly given in configuration using 'implementation' attribute: '" + implementation + "' cannot be loaded";
                throw new ComponentConfigurationException(msg, (Throwable)e);
            }
        }
        return retValue;
    }

    protected Class loadClass(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class<?> retValue;
        try {
            retValue = classLoader.loadClass(classname);
        }
        catch (ClassNotFoundException e) {
            throw new ComponentConfigurationException("Error loading class '" + classname + "'", (Throwable)e);
        }
        return retValue;
    }

    protected Object instantiateObject(String classname, ClassLoader classLoader) throws ComponentConfigurationException {
        Class clazz = this.loadClass(classname, classLoader);
        return this.instantiateObject(clazz);
    }

    protected Object instantiateObject(Class clazz) throws ComponentConfigurationException {
        try {
            Object retValue = clazz.newInstance();
            return retValue;
        }
        catch (IllegalAccessException e) {
            throw new ComponentConfigurationException("Class '" + clazz.getName() + "' cannot be instantiated", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ComponentConfigurationException("Class '" + clazz.getName() + "' cannot be instantiated", (Throwable)e);
        }
    }

    protected String fromXML(String elementName) {
        return StringUtils.lowercaseFirstLetter(StringUtils.removeAndHump(elementName, "-"));
    }

    protected String toXML(String fieldName) {
        return StringUtils.addAndDeHump(fieldName);
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator, Class type) throws ComponentConfigurationException {
        Object v = this.fromExpression(configuration, expressionEvaluator);
        if (v != null && !type.isAssignableFrom(v.getClass())) {
            String msg = "Cannot assign configuration entry '" + configuration.getName() + "' to '" + type + "' from '" + configuration.getValue(null) + "', which is of type " + v.getClass();
            throw new ComponentConfigurationException(configuration, msg);
        }
        return v;
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        Object v = null;
        String value = configuration.getValue(null);
        if (value != null && value.length() > 0) {
            try {
                v = expressionEvaluator.evaluate(value);
            }
            catch (ExpressionEvaluationException e) {
                String msg = "Error evaluating the expression '" + value + "' for configuration value '" + configuration.getName() + "'";
                throw new ComponentConfigurationException(configuration, msg, e);
            }
        }
        if (v == null && (value = configuration.getAttribute("default-value", null)) != null && value.length() > 0) {
            try {
                v = expressionEvaluator.evaluate(value);
            }
            catch (ExpressionEvaluationException e) {
                String msg = "Error evaluating the expression '" + value + "' for configuration value '" + configuration.getName() + "'";
                throw new ComponentConfigurationException(configuration, msg, e);
            }
        }
        return v;
    }

    @Override
    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator) throws ComponentConfigurationException {
        return this.fromConfiguration(converterLookup, configuration, type, baseType, classLoader, expressionEvaluator, null);
    }
}

