/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.codehaus.plexus.ComponentRegistry;
import org.gradle.internal.impldep.org.codehaus.plexus.ContainerConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.DefaultContainerConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.MutablePlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainerException;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.ClassWorld;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.CastUtils;
import org.gradle.internal.impldep.org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.gradle.internal.impldep.org.codehaus.plexus.component.discovery.ComponentDiscovererManager;
import org.gradle.internal.impldep.org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.gradle.internal.impldep.org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.gradle.internal.impldep.org.codehaus.plexus.component.factory.ComponentFactoryManager;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.io.PlexusTools;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.PlexusConfigurationMerger;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.source.ConfigurationSource;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.gradle.internal.impldep.org.codehaus.plexus.container.initialization.ContainerInitializationPhase;
import org.gradle.internal.impldep.org.codehaus.plexus.context.Context;
import org.gradle.internal.impldep.org.codehaus.plexus.context.ContextException;
import org.gradle.internal.impldep.org.codehaus.plexus.context.ContextMapAdapter;
import org.gradle.internal.impldep.org.codehaus.plexus.context.DefaultContext;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.AbstractLogEnabled;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.LoggerManager;
import org.gradle.internal.impldep.org.codehaus.plexus.util.IOUtil;
import org.gradle.internal.impldep.org.codehaus.plexus.util.InterpolationFilterReader;
import org.gradle.internal.impldep.org.codehaus.plexus.util.ReaderFactory;

public class DefaultPlexusContainer
extends AbstractLogEnabled
implements MutablePlexusContainer {
    protected static final String DEFAULT_CONTAINER_NAME = "default";
    protected static final String DEFAULT_REALM_NAME = "plexus.core";
    protected Context containerContext;
    protected PlexusConfiguration configuration;
    protected Reader configurationReader;
    protected ClassWorld classWorld;
    protected ClassRealm containerRealm;
    private ComponentRegistry componentRegistry;
    protected ComponentDiscovererManager componentDiscovererManager;
    protected ComponentFactoryManager componentFactoryManager;
    protected LoggerManager loggerManager;
    protected ConfigurationSource configurationSource;
    private ThreadLocal<ClassRealm> lookupRealm = new ThreadLocal();

    @Override
    public void addComponent(Object component, String role) {
        this.addComponent(component, role, DEFAULT_CONTAINER_NAME);
    }

    @Override
    public <T> void addComponent(T component, Class<?> role, String roleHint) {
        this.addComponent(component, role.getName(), roleHint);
    }

    public void addComponent(Object component, String role, String roleHint) {
        if (roleHint == null) {
            roleHint = DEFAULT_CONTAINER_NAME;
        }
        this.getComponentRegistry().addComponent(component, role, roleHint);
    }

    @Override
    public ClassRealm setLookupRealm(ClassRealm realm) {
        ClassRealm oldRealm = this.lookupRealm.get();
        this.lookupRealm.set(realm);
        return oldRealm;
    }

    @Override
    public ClassRealm getLookupRealm() {
        return this.lookupRealm.get();
    }

    public DefaultPlexusContainer() throws PlexusContainerException {
        this.construct(new DefaultContainerConfiguration());
    }

    public DefaultPlexusContainer(ContainerConfiguration c) throws PlexusContainerException {
        this.construct(c);
    }

    @Override
    public ClassRealm createChildRealm(String id) {
        try {
            return this.containerRealm.createChildRealm(id);
        }
        catch (DuplicateRealmException e) {
            try {
                return this.classWorld.getRealm(id);
            }
            catch (NoSuchRealmException e1) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void construct(ContainerConfiguration c) throws PlexusContainerException {
        block19: {
            this.configurationSource = c.getConfigurationSource();
            this.classWorld = c.getClassWorld();
            if (this.classWorld == null) {
                this.classWorld = new ClassWorld(DEFAULT_REALM_NAME, Thread.currentThread().getContextClassLoader());
            }
            this.containerRealm = c.getRealm();
            if (this.containerRealm == null) {
                try {
                    this.containerRealm = this.classWorld.getRealm(DEFAULT_REALM_NAME);
                }
                catch (NoSuchRealmException e) {
                    this.containerRealm = this.classWorld.getRealms().iterator().next();
                    if (this.containerRealm != null) break block19;
                    System.err.println("No container realm! Expect errors.");
                    new Throwable().printStackTrace();
                }
            }
        }
        this.setLookupRealm(this.containerRealm);
        this.containerContext = c.getContext() != null ? new DefaultContext(c.getContext()) : new DefaultContext();
        InputStream in = null;
        if (c.getContainerConfiguration() != null) {
            in = this.toStream(c.getContainerConfiguration());
        }
        try {
            if (c.getContainerConfigurationURL() != null) {
                in = c.getContainerConfigurationURL().openStream();
            }
        }
        catch (IOException e) {
            throw new PlexusContainerException("Error reading configuration URL", e);
        }
        try {
            this.configurationReader = in == null ? null : ReaderFactory.newXmlReader(in);
        }
        catch (IOException e) {
            throw new PlexusContainerException("Error reading configuration file", e);
        }
        try {
            this.initialize(c);
            this.start();
        }
        finally {
            IOUtil.close(this.configurationReader);
        }
        for (Class clazz : c.getComponentDiscoverers()) {
            try {
                ComponentDiscoverer cd = (ComponentDiscoverer)this.lookup(clazz);
                this.componentDiscovererManager.addComponentDiscoverer(cd);
            }
            catch (ComponentLookupException e) {}
        }
        for (Class clazz : c.getComponentDiscoveryListeners()) {
            try {
                ComponentDiscoveryListener cdl = (ComponentDiscoveryListener)this.lookup(clazz);
                this.componentDiscovererManager.registerComponentDiscoveryListener(cdl);
            }
            catch (ComponentLookupException e) {}
        }
    }

    private Class<?> getInterfaceClass(String role, String hint) {
        ComponentDescriptor<?> cd = hint == null ? this.getComponentDescriptor(role) : this.getComponentDescriptor(role, hint);
        if (cd != null) {
            try {
                ClassRealm realm = this.getLookupRealm();
                if (realm != null) {
                    return realm.loadClass(role);
                }
                ClassLoader loader = cd.getImplementationClass().getClassLoader();
                if (loader != null) {
                    return loader.loadClass(role);
                }
            }
            catch (ClassNotFoundException e) {
                return Object.class;
            }
        }
        return Object.class;
    }

    private Class<?> getRoleClass(String role) {
        return this.getInterfaceClass(role, null);
    }

    private Class<?> getRoleClass(String role, String hint) {
        return this.getInterfaceClass(role, hint);
    }

    @Override
    public Object lookup(String role) throws ComponentLookupException {
        return this.componentRegistry.lookup(this.getRoleClass(role), role, "");
    }

    @Override
    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.componentRegistry.lookup(this.getRoleClass(role, roleHint), role, roleHint);
    }

    @Override
    public <T> T lookup(Class<T> type) throws ComponentLookupException {
        return this.componentRegistry.lookup(type, type.getName(), "");
    }

    @Override
    public <T> T lookup(Class<T> type, String roleHint) throws ComponentLookupException {
        return this.componentRegistry.lookup(type, type.getName(), roleHint);
    }

    @Override
    public <T> T lookup(Class<T> type, String role, String roleHint) throws ComponentLookupException {
        return this.componentRegistry.lookup(type, role, roleHint);
    }

    @Override
    public <T> T lookup(ComponentDescriptor<T> componentDescriptor) throws ComponentLookupException {
        return this.componentRegistry.lookup(componentDescriptor);
    }

    @Override
    public List<Object> lookupList(String role) throws ComponentLookupException {
        return CastUtils.cast(this.componentRegistry.lookupList(this.getRoleClass(role), role, null));
    }

    @Override
    public List<Object> lookupList(String role, List<String> roleHints) throws ComponentLookupException {
        return CastUtils.cast(this.componentRegistry.lookupList(this.getRoleClass(role), role, roleHints));
    }

    @Override
    public <T> List<T> lookupList(Class<T> type) throws ComponentLookupException {
        return this.componentRegistry.lookupList(type, type.getName(), null);
    }

    @Override
    public <T> List<T> lookupList(Class<T> type, List<String> roleHints) throws ComponentLookupException {
        return this.componentRegistry.lookupList(type, type.getName(), roleHints);
    }

    @Override
    public Map<String, Object> lookupMap(String role) throws ComponentLookupException {
        return CastUtils.cast(this.componentRegistry.lookupMap(this.getRoleClass(role), role, null));
    }

    @Override
    public Map<String, Object> lookupMap(String role, List<String> roleHints) throws ComponentLookupException {
        return CastUtils.cast(this.componentRegistry.lookupMap(this.getRoleClass(role), role, roleHints));
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> type) throws ComponentLookupException {
        return this.componentRegistry.lookupMap(type, type.getName(), null);
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> type, List<String> roleHints) throws ComponentLookupException {
        return this.componentRegistry.lookupMap(type, type.getName(), roleHints);
    }

    @Override
    public boolean hasComponent(String role) {
        return this.componentRegistry.getComponentDescriptor(Object.class, role, "") != null;
    }

    @Override
    public boolean hasComponent(String role, String roleHint) {
        return this.componentRegistry.getComponentDescriptor(Object.class, role, roleHint) != null;
    }

    @Override
    public boolean hasComponent(Class<?> type) {
        return this.componentRegistry.getComponentDescriptor(type, type.getName(), "") != null;
    }

    @Override
    public boolean hasComponent(Class<?> type, String roleHint) {
        return this.componentRegistry.getComponentDescriptor(type, type.getName(), roleHint) != null;
    }

    @Override
    public boolean hasComponent(Class<?> type, String role, String roleHint) {
        return this.componentRegistry.getComponentDescriptor(type, role, roleHint) != null;
    }

    @Override
    public ComponentDescriptor<?> getComponentDescriptor(String role) {
        return this.componentRegistry.getComponentDescriptor(Object.class, role, "");
    }

    @Override
    public ComponentDescriptor<?> getComponentDescriptor(String role, String roleHint) {
        return this.componentRegistry.getComponentDescriptor(Object.class, role, roleHint);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String role, String roleHint) {
        return this.componentRegistry.getComponentDescriptor(type, role, roleHint);
    }

    @Override
    public Map<String, ComponentDescriptor<?>> getComponentDescriptorMap(String role) {
        return CastUtils.cast(this.componentRegistry.getComponentDescriptorMap(Object.class, role));
    }

    @Override
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type, String role) {
        return this.componentRegistry.getComponentDescriptorMap(type, role);
    }

    @Override
    public List<ComponentDescriptor<?>> getComponentDescriptorList(String role) {
        return CastUtils.cast(this.componentRegistry.getComponentDescriptorList(Object.class, role));
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type, String role) {
        return this.componentRegistry.getComponentDescriptorList(type, role);
    }

    @Override
    public void addComponentDescriptor(ComponentDescriptor<?> componentDescriptor) throws CycleDetectedInComponentGraphException {
        if (componentDescriptor.getRealm() == null) {
            componentDescriptor.setRealm(this.containerRealm);
        }
        this.componentRegistry.addComponentDescriptor(componentDescriptor);
    }

    @Override
    public void release(Object component) throws ComponentLifecycleException {
        this.componentRegistry.release(component);
    }

    @Override
    public void releaseAll(Map<String, ?> components) throws ComponentLifecycleException {
        for (Object component : components.values()) {
            this.release(component);
        }
    }

    @Override
    public void releaseAll(List<?> components) throws ComponentLifecycleException {
        for (Object component : components) {
            this.release(component);
        }
    }

    protected void initialize(ContainerConfiguration containerConfiguration) throws PlexusContainerException {
        try {
            this.initializeConfiguration(containerConfiguration);
            this.initializePhases(containerConfiguration);
            this.containerContext.put("plexus", this);
            this.discoverComponents(this.getContainerRealm());
            PlexusConfiguration[] loadOnStartComponents = this.getConfiguration().getChild("load-on-start").getChildren("component");
            this.getLogger().debug("Found " + loadOnStartComponents.length + " components to load on start");
            ClassLoader prevCl = Thread.currentThread().getContextClassLoader();
            try {
                for (PlexusConfiguration loadOnStartComponent : loadOnStartComponents) {
                    String role = loadOnStartComponent.getChild("role").getValue(null);
                    String roleHint = loadOnStartComponent.getChild("role-hint").getValue(null);
                    if (role == null) {
                        throw new PlexusContainerException("Missing 'role' element from load-on-start.");
                    }
                    if (roleHint == null) {
                        roleHint = DEFAULT_CONTAINER_NAME;
                    }
                    if (roleHint.equals("*")) {
                        this.getLogger().info("Loading on start all components with [role]: [" + role + "]");
                        this.lookupList(role);
                        continue;
                    }
                    this.getLogger().info("Loading on start [role,roleHint]: [" + role + "," + roleHint + "]");
                    this.lookup(role, roleHint);
                }
            }
            catch (ComponentLookupException e) {
                throw new PlexusContainerException("Error looking up load-on-start component.", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevCl);
            }
        }
        catch (ContextException e) {
            throw new PlexusContainerException("Error processing configuration", e);
        }
        catch (PlexusConfigurationException e) {
            throw new PlexusContainerException("Error configuring components", e);
        }
        catch (IOException e) {
            throw new PlexusContainerException("Error reading configuration file", e);
        }
        catch (CycleDetectedInComponentGraphException e) {
            throw new PlexusContainerException("Cycle detected in component graph in the system: ", e);
        }
    }

    protected void initializePhases(ContainerConfiguration containerConfiguration) throws PlexusContainerException {
        ContainerInitializationPhase[] initPhases = containerConfiguration.getInitializationPhases();
        ContainerInitializationContext initializationContext = new ContainerInitializationContext(this, this.classWorld, this.containerRealm, this.configuration, containerConfiguration);
        for (ContainerInitializationPhase phase : initPhases) {
            try {
                phase.execute(initializationContext);
            }
            catch (Exception e) {
                throw new PlexusContainerException("Error initializaing container in " + phase.getClass().getName() + ".", e);
            }
        }
    }

    protected void start() throws PlexusContainerException {
        this.configuration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            this.componentRegistry.dispose();
            boolean needToDisposeRealm = false;
            try {
                this.containerRealm.setParentRealm(null);
                if (needToDisposeRealm) {
                    this.classWorld.disposeRealm(this.containerRealm.getId());
                }
            }
            catch (NoSuchRealmException e) {
                this.getLogger().debug("Failed to dispose realm.");
            }
        }
        finally {
            this.lookupRealm.set(null);
        }
    }

    @Override
    public void addContextValue(Object key, Object value) {
        this.containerContext.put(key, value);
    }

    @Override
    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public void setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
    }

    @Override
    public ClassRealm getContainerRealm() {
        return this.containerRealm;
    }

    public void setContainerRealm(ClassRealm containerRealm) {
        this.containerRealm = containerRealm;
    }

    @Override
    public Context getContext() {
        return this.containerContext;
    }

    protected void initializeConfiguration(ContainerConfiguration c) throws PlexusConfigurationException, ContextException, IOException {
        this.configuration = new XmlPlexusConfiguration("plexus");
        if (this.configurationReader != null) {
            PlexusConfiguration userConfiguration = PlexusTools.buildConfiguration("<User Specified Configuration Reader>", this.getInterpolationConfigurationReader(this.configurationReader));
            this.configuration = PlexusConfigurationMerger.merge(userConfiguration, this.configuration);
        }
    }

    protected Reader getInterpolationConfigurationReader(Reader reader) {
        return new InterpolationFilterReader(reader, new ContextMapAdapter(this.containerContext));
    }

    @Override
    public Logger getLogger() {
        return super.getLogger();
    }

    @Override
    public void registerComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.registerComponentDiscoveryListener(listener);
    }

    @Override
    public void removeComponentDiscoveryListener(ComponentDiscoveryListener listener) {
        this.componentDiscovererManager.removeComponentDiscoveryListener(listener);
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public void setComponentRegistry(ComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    @Override
    public ComponentDiscovererManager getComponentDiscovererManager() {
        return this.componentDiscovererManager;
    }

    @Override
    public void setComponentDiscovererManager(ComponentDiscovererManager componentDiscovererManager) {
        this.componentDiscovererManager = componentDiscovererManager;
    }

    @Override
    public ComponentFactoryManager getComponentFactoryManager() {
        return this.componentFactoryManager;
    }

    @Override
    public void setComponentFactoryManager(ComponentFactoryManager componentFactoryManager) {
        this.componentFactoryManager = componentFactoryManager;
    }

    @Override
    public PlexusConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(PlexusConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ClassRealm getComponentRealm(String realmId) {
        ClassRealm realm = null;
        try {
            realm = this.classWorld.getRealm(realmId);
        }
        catch (NoSuchRealmException noSuchRealmException) {
            // empty catch block
        }
        if (realm == null) {
            realm = this.containerRealm;
        }
        return realm;
    }

    @Override
    public void removeComponentRealm(ClassRealm realm) throws PlexusContainerException {
        if (this.getContainerRealm().getId().equals(realm.getId())) {
            throw new IllegalArgumentException("Cannot remove container realm: " + realm.getId() + "\n(trying to remove container realm as if it were a component realm).");
        }
        this.componentRegistry.removeComponentRealm(realm);
        ClassRealm lookupRealm = this.getLookupRealm();
        if (lookupRealm != null && lookupRealm.getId().equals(realm.getId())) {
            this.setLookupRealm(this.getContainerRealm());
        }
    }

    private InputStream toStream(String resource) throws PlexusContainerException {
        InputStream is;
        if (resource == null) {
            return null;
        }
        String relativeResource = resource;
        if (resource.startsWith("/")) {
            relativeResource = resource.substring(1);
        }
        if ((is = this.getClass().getClassLoader().getResourceAsStream(relativeResource)) == null) {
            try {
                return new FileInputStream(resource);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return is;
    }

    @Override
    public ClassRealm getLookupRealm(Object component) {
        if (component.getClass().getClassLoader() instanceof ClassRealm) {
            return (ClassRealm)component.getClass().getClassLoader();
        }
        return this.getLookupRealm();
    }

    @Override
    public void setConfigurationSource(ConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
    }

    @Override
    public ConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    @Override
    public void setLoggerManager(LoggerManager loggerManager) {
        this.loggerManager = loggerManager;
    }

    @Override
    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm) throws PlexusConfigurationException, CycleDetectedInComponentGraphException {
        return this.discoverComponents(realm, null);
    }

    @Override
    public List<ComponentDescriptor<?>> discoverComponents(ClassRealm realm, Object data) throws PlexusConfigurationException, CycleDetectedInComponentGraphException {
        ArrayList<ComponentSetDescriptor> componentSetDescriptors = new ArrayList<ComponentSetDescriptor>();
        ArrayList discoveredComponentDescriptors = new ArrayList();
        for (ComponentDiscoverer componentDiscoverer : this.getComponentDiscovererManager().getComponentDiscoverers()) {
            for (ComponentSetDescriptor componentSetDescriptor : componentDiscoverer.findComponents(this.getContext(), realm)) {
                componentSetDescriptors.add(componentSetDescriptor);
                ComponentDiscoveryEvent event = new ComponentDiscoveryEvent(componentSetDescriptor, data);
                this.componentDiscovererManager.fireComponentDiscoveryEvent(event);
                for (ComponentDescriptor<?> componentDescriptor : componentSetDescriptor.getComponents()) {
                    this.addComponentDescriptor(componentDescriptor);
                    discoveredComponentDescriptors.add(componentDescriptor);
                }
            }
        }
        return discoveredComponentDescriptors;
    }
}

