/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.plugin.internal;

import org.gradle.internal.impldep.org.sonatype.aether.RepositoryException;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyGraphTransformationContext;
import org.gradle.internal.impldep.org.sonatype.aether.collection.DependencyGraphTransformer;
import org.gradle.internal.impldep.org.sonatype.aether.graph.Dependency;
import org.gradle.internal.impldep.org.sonatype.aether.graph.DependencyNode;
import org.gradle.internal.impldep.org.sonatype.aether.util.artifact.DefaultArtifact;
import org.gradle.internal.impldep.org.sonatype.aether.util.graph.DefaultDependencyNode;

class PlexusUtilsInjector
implements DependencyGraphTransformer {
    private static final String GID = "org.codehaus.plexus";
    private static final String AID = "plexus-utils";
    private static final String VER = "1.1";
    private static final String EXT = "jar";

    PlexusUtilsInjector() {
    }

    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        if (this.findPlexusUtils(node) == null) {
            DefaultArtifact pu = new DefaultArtifact("org.gradle.internal.impldep.org.codehaus.plexus", AID, null, EXT, VER);
            DefaultDependencyNode child = new DefaultDependencyNode(new Dependency(pu, "runtime"));
            child.setRepositories(node.getRepositories());
            child.setRequestContext(node.getRequestContext());
            node.getChildren().add(child);
        }
        return node;
    }

    private DependencyNode findPlexusUtils(DependencyNode node) {
        Artifact artifact = node.getDependency().getArtifact();
        if (AID.equals(artifact.getArtifactId()) && "org.gradle.internal.impldep.org.codehaus.plexus".equals(artifact.getGroupId()) && EXT.equals(artifact.getExtension()) && "".equals(artifact.getClassifier())) {
            return node;
        }
        for (DependencyNode child : node.getChildren()) {
            DependencyNode result = this.findPlexusUtils(child);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

