/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.impldep.org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.gradle.internal.impldep.org.apache.maven.project.MavenProject;

public class BuildLogItem {
    private final ExecutionPlanItem executionPlanItem;
    private final MavenProject project;
    private final long startTime;
    private long endTime;
    private final List<DependencyLogEntry> dependencies = Collections.synchronizedList(new ArrayList());

    public BuildLogItem(MavenProject project, ExecutionPlanItem executionPlanItem) {
        this.executionPlanItem = executionPlanItem;
        this.project = project;
        this.startTime = System.currentTimeMillis();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setComplete() {
        this.endTime = System.currentTimeMillis();
    }

    public void addWait(MavenProject upstreamProject, ExecutionPlanItem inSchedule, long startWait) {
        long now = System.currentTimeMillis();
        this.dependencies.add(new DependencyLogEntry(upstreamProject, inSchedule, startWait, now, null));
    }

    public void addDependency(MavenProject upstreamProject, String message) {
        this.dependencies.add(new DependencyLogEntry(upstreamProject, message));
    }

    public String toString(long rootStart) {
        StringBuilder result = new StringBuilder();
        result.append(String.format("%1d  %2d ", this.startTime - rootStart, this.endTime - rootStart));
        result.append(this.project.getName());
        result.append(" ");
        result.append(BuildLogItem.getMojoExecutionDescription(this.executionPlanItem));
        if (this.dependencies.size() > 0) {
            result.append("\n");
            for (DependencyLogEntry waitLogEntry : this.dependencies) {
                result.append("    ");
                result.append(waitLogEntry.toString());
                result.append("\n");
            }
        }
        return result.toString();
    }

    public Object toGraph(long rootStart) {
        StringBuilder result = new StringBuilder();
        if (this.dependencies.size() > 0) {
            for (DependencyLogEntry waitLogEntry : this.dependencies) {
                result.append("        ");
                result.append(BuildLogItem.nodeKey(this.project, this.executionPlanItem));
                result.append(" ->   ");
                result.append(waitLogEntry.toNodeKey());
                result.append(waitLogEntry.toNodeDescription(rootStart));
                result.append("\n");
            }
        } else {
            result.append("        ");
            result.append(BuildLogItem.nodeKey(this.project, this.executionPlanItem));
            result.append("\n");
        }
        return result.toString();
    }

    private static String nodeKey(MavenProject mavenProject, ExecutionPlanItem executionPlanItem) {
        String key = mavenProject.getArtifactId();
        if (executionPlanItem != null) {
            key = key + "_" + BuildLogItem.getMojoExecutionDescription(executionPlanItem);
        }
        return key.replace(".", "_").replace(":", "_");
    }

    private static String getMojoExecutionDescription(ExecutionPlanItem executionPlanItem) {
        if (executionPlanItem.getMojoExecution() != null) {
            return executionPlanItem.getMojoExecution().getArtifactId() + BuildLogItem.getLifeCyclePhase(executionPlanItem);
        }
        return "";
    }

    private static String getLifeCyclePhase(ExecutionPlanItem executionPlanItem) {
        return executionPlanItem.getLifecyclePhase() != null ? "[" + executionPlanItem.getLifecyclePhase() + "]" : "";
    }

    class DependencyLogEntry {
        private final ExecutionPlanItem executionPlanItem;
        private final MavenProject upstreamProject;
        private final Long start;
        private final Long stop;
        private final String message;

        DependencyLogEntry(MavenProject upstreamProject, ExecutionPlanItem executionPlanItem, Long start, Long stop, String message) {
            this.upstreamProject = upstreamProject;
            this.executionPlanItem = executionPlanItem;
            this.start = start;
            this.stop = stop;
            this.message = message;
        }

        DependencyLogEntry(MavenProject upstreamProject, String message) {
            this(upstreamProject, null, null, null, message);
        }

        public String toString() {
            return this.upstreamProject.getName() + ":" + this.getExecutionPlanItem() + this.getElapsed() + this.getMessage();
        }

        public String toNodeKey() {
            return BuildLogItem.nodeKey(this.upstreamProject, this.executionPlanItem);
        }

        public String toNodeDescription(long rootStart) {
            return "";
        }

        private String getMessage() {
            return this.message != null ? this.message : "";
        }

        private String getExecutionPlanItem() {
            if (this.executionPlanItem != null) {
                return BuildLogItem.getMojoExecutionDescription(this.executionPlanItem);
            }
            return "";
        }

        private String getElapsed() {
            if (this.start != null && this.stop != null) {
                long elapsed = this.stop - this.start;
                return elapsed > 0L ? ", wait=" + elapsed : "";
            }
            return "";
        }
    }
}

