/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform;

import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.NotificationConfiguration;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform.LambdaConfigurationStaxUnmarshaller;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform.QueueConfigurationStaxUnmarshaller;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.transform.TopicConfigurationStaxUnmarshaller;
import org.gradle.internal.impldep.com.amazonaws.transform.StaxUnmarshallerContext;
import org.gradle.internal.impldep.com.amazonaws.transform.Unmarshaller;
import org.gradle.internal.impldep.com.amazonaws.util.XmlUtils;

public class BucketNotificationConfigurationStaxUnmarshaller
implements Unmarshaller<BucketNotificationConfiguration, InputStream> {
    private static final BucketNotificationConfigurationStaxUnmarshaller instance = new BucketNotificationConfigurationStaxUnmarshaller();

    public static BucketNotificationConfigurationStaxUnmarshaller getInstance() {
        return instance;
    }

    private BucketNotificationConfigurationStaxUnmarshaller() {
    }

    @Override
    public BucketNotificationConfiguration unmarshall(InputStream inputStream) throws Exception {
        StaxUnmarshallerContext context = new StaxUnmarshallerContext(XmlUtils.getXmlInputFactory().createXMLEventReader(inputStream));
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        BucketNotificationConfiguration config = new BucketNotificationConfiguration();
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return config;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                Map.Entry<String, NotificationConfiguration> entry;
                if (context.testExpression("TopicConfiguration", targetDepth)) {
                    entry = TopicConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("QueueConfiguration", targetDepth)) {
                    entry = QueueConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                    config.addConfiguration(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!context.testExpression("CloudFunctionConfiguration", targetDepth)) continue;
                entry = LambdaConfigurationStaxUnmarshaller.getInstance().unmarshall(context);
                config.addConfiguration(entry.getKey(), entry.getValue());
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return config;
    }
}

