/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ThrowableConsumer;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TroveUtil {
    @NotNull
    public static <T> Stream<T> streamValues(@NotNull TIntObjectHashMap<? extends T> map2) {
        if (map2 == null) {
            TroveUtil.$$$reportNull$$$0(0);
        }
        TIntObjectIterator it = map2.iterator();
        Stream<Object> stream = Stream.generate(() -> {
            it.advance();
            return it.value();
        }).limit(map2.size());
        if (stream == null) {
            TroveUtil.$$$reportNull$$$0(1);
        }
        return stream;
    }

    @NotNull
    public static IntStream streamKeys(@NotNull TIntObjectHashMap<?> map2) {
        if (map2 == null) {
            TroveUtil.$$$reportNull$$$0(2);
        }
        TIntObjectIterator it = map2.iterator();
        IntStream intStream = IntStream.generate(() -> {
            it.advance();
            return it.key();
        }).limit(map2.size());
        if (intStream == null) {
            TroveUtil.$$$reportNull$$$0(3);
        }
        return intStream;
    }

    @NotNull
    public static IntStream stream(@NotNull TIntArrayList list) {
        if (list == null) {
            TroveUtil.$$$reportNull$$$0(4);
        }
        if (list.isEmpty()) {
            IntStream intStream = IntStream.empty();
            if (intStream == null) {
                TroveUtil.$$$reportNull$$$0(5);
            }
            return intStream;
        }
        IntStream intStream = IntStream.range(0, list.size()).map(arg_0 -> ((TIntArrayList)list).get(arg_0));
        if (intStream == null) {
            TroveUtil.$$$reportNull$$$0(6);
        }
        return intStream;
    }

    @Nullable
    public static IntSet intersect(IntSet ... sets) {
        if (sets == null) {
            TroveUtil.$$$reportNull$$$0(7);
        }
        Arrays.sort(sets, (set1, set2) -> {
            if (set1 == null) {
                return -1;
            }
            if (set2 == null) {
                return 1;
            }
            return set1.size() - set2.size();
        });
        IntSet result2 = null;
        for (IntSet set : sets) {
            result2 = TroveUtil.intersect(result2, set);
        }
        return result2;
    }

    public static boolean intersects(@NotNull TIntHashSet set1, @NotNull TIntHashSet set2) {
        if (set1 == null) {
            TroveUtil.$$$reportNull$$$0(8);
        }
        if (set2 == null) {
            TroveUtil.$$$reportNull$$$0(9);
        }
        if (set1.size() <= set2.size()) {
            return !set1.forEach(value -> !set2.contains(value));
        }
        return TroveUtil.intersects(set2, set1);
    }

    @Contract(value="null, null -> null; !null, _ -> !null; _, !null -> !null")
    @Nullable
    public static TIntHashSet intersect(@Nullable TIntHashSet set1, @Nullable TIntHashSet set2) {
        if (set1 == null) {
            return set2;
        }
        if (set2 == null) {
            return set1;
        }
        TIntHashSet result2 = new TIntHashSet();
        if (set1.size() < set2.size()) {
            TroveUtil.intersectTo(set1, set2, result2);
        } else {
            TroveUtil.intersectTo(set2, set1, result2);
        }
        return result2;
    }

    @Contract(value="null, null -> null; !null, _ -> !null; _, !null -> !null")
    @Nullable
    public static IntSet intersect(@Nullable IntSet set1, @Nullable IntSet set2) {
        if (set1 == null) {
            return set2;
        }
        if (set2 == null) {
            return set1;
        }
        IntOpenHashSet result2 = new IntOpenHashSet();
        if (set1.size() < set2.size()) {
            TroveUtil.intersectTo(set1, set2, (IntSet)result2);
        } else {
            TroveUtil.intersectTo(set2, set1, (IntSet)result2);
        }
        return result2;
    }

    private static void intersectTo(@NotNull TIntHashSet small, @NotNull TIntHashSet big, @NotNull TIntHashSet result2) {
        if (small == null) {
            TroveUtil.$$$reportNull$$$0(10);
        }
        if (big == null) {
            TroveUtil.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            TroveUtil.$$$reportNull$$$0(12);
        }
        small.forEach(value -> {
            if (big.contains(value)) {
                result2.add(value);
            }
            return true;
        });
    }

    private static void intersectTo(@NotNull IntSet small, @NotNull IntSet big, @NotNull IntSet result2) {
        if (small == null) {
            TroveUtil.$$$reportNull$$$0(13);
        }
        if (big == null) {
            TroveUtil.$$$reportNull$$$0(14);
        }
        if (result2 == null) {
            TroveUtil.$$$reportNull$$$0(15);
        }
        IntIterator iterator = small.iterator();
        while (iterator.hasNext()) {
            int value = iterator.nextInt();
            if (!big.contains(value)) continue;
            result2.add(value);
        }
    }

    public static void addAll(@NotNull TIntHashSet where, @NotNull TIntHashSet what) {
        if (where == null) {
            TroveUtil.$$$reportNull$$$0(16);
        }
        if (what == null) {
            TroveUtil.$$$reportNull$$$0(17);
        }
        what.forEach(value -> {
            where.add(value);
            return true;
        });
    }

    public static void addAll(@NotNull TIntHashSet where, @NotNull Collection<Integer> what) {
        if (where == null) {
            TroveUtil.$$$reportNull$$$0(18);
        }
        if (what == null) {
            TroveUtil.$$$reportNull$$$0(19);
        }
        what.forEach(value -> where.add(value.intValue()));
    }

    public static void addAll(@NotNull Collection<? super Integer> where, @NotNull TIntHashSet what) {
        if (where == null) {
            TroveUtil.$$$reportNull$$$0(20);
        }
        if (what == null) {
            TroveUtil.$$$reportNull$$$0(21);
        }
        what.forEach(value -> where.add(value));
    }

    public static <V> void putAll(@NotNull TIntObjectHashMap<? super V> where, @NotNull TIntObjectHashMap<? extends V> what) {
        if (where == null) {
            TroveUtil.$$$reportNull$$$0(22);
        }
        if (what == null) {
            TroveUtil.$$$reportNull$$$0(23);
        }
        what.forEachEntry((index, value) -> {
            where.put(index, value);
            return true;
        });
    }

    @NotNull
    public static IntSet union(@NotNull Collection<? extends IntSet> sets) {
        if (sets == null) {
            TroveUtil.$$$reportNull$$$0(24);
        }
        IntOpenHashSet result2 = new IntOpenHashSet();
        for (IntSet intSet : sets) {
            result2.addAll((IntCollection)intSet);
        }
        IntOpenHashSet intOpenHashSet = result2;
        if (intOpenHashSet == null) {
            TroveUtil.$$$reportNull$$$0(25);
        }
        return intOpenHashSet;
    }

    @NotNull
    public static IntStream stream(@NotNull TIntHashSet set) {
        if (set == null) {
            TroveUtil.$$$reportNull$$$0(26);
        }
        TIntIterator it = set.iterator();
        IntStream intStream = IntStream.generate(() -> ((TIntIterator)it).next()).limit(set.size());
        if (intStream == null) {
            TroveUtil.$$$reportNull$$$0(27);
        }
        return intStream;
    }

    @NotNull
    public static <T> List<T> map2List(@NotNull TIntHashSet set, @NotNull IntFunction<? extends T> function) {
        if (set == null) {
            TroveUtil.$$$reportNull$$$0(28);
        }
        if (function == null) {
            TroveUtil.$$$reportNull$$$0(29);
        }
        List list = TroveUtil.stream(set).mapToObj(function).collect(Collectors.toList());
        if (list == null) {
            TroveUtil.$$$reportNull$$$0(30);
        }
        return list;
    }

    @NotNull
    public static <T> TIntObjectHashMap<T> map2MapNotNull(@NotNull TIntHashSet set, @NotNull IntFunction<? extends T> function) {
        if (set == null) {
            TroveUtil.$$$reportNull$$$0(31);
        }
        if (function == null) {
            TroveUtil.$$$reportNull$$$0(32);
        }
        TIntObjectHashMap result2 = new TIntObjectHashMap();
        set.forEach(it -> {
            Object value = function.apply(it);
            if (value != null) {
                result2.put(it, value);
            }
            return true;
        });
        TIntObjectHashMap tIntObjectHashMap = result2;
        if (tIntObjectHashMap == null) {
            TroveUtil.$$$reportNull$$$0(33);
        }
        return tIntObjectHashMap;
    }

    @NotNull
    public static <T> TIntHashSet map2IntSet(@NotNull Collection<? extends T> set, @NotNull ToIntFunction<? super T> function) {
        if (set == null) {
            TroveUtil.$$$reportNull$$$0(34);
        }
        if (function == null) {
            TroveUtil.$$$reportNull$$$0(35);
        }
        TIntHashSet result2 = new TIntHashSet();
        for (T t : set) {
            result2.add(function.applyAsInt(t));
        }
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            TroveUtil.$$$reportNull$$$0(36);
        }
        return tIntHashSet;
    }

    @NotNull
    public static <T> Map<T, TIntHashSet> group(@NotNull TIntHashSet set, @NotNull IntFunction<? extends T> function) {
        if (set == null) {
            TroveUtil.$$$reportNull$$$0(37);
        }
        if (function == null) {
            TroveUtil.$$$reportNull$$$0(38);
        }
        HashMap result2 = new HashMap();
        set.forEach(it -> {
            Object key = function.apply(it);
            TIntHashSet values = (TIntHashSet)result2.get(key);
            if (values == null) {
                values = new TIntHashSet();
                result2.put(key, values);
            }
            values.add(it);
            return true;
        });
        HashMap hashMap = result2;
        if (hashMap == null) {
            TroveUtil.$$$reportNull$$$0(39);
        }
        return hashMap;
    }

    public static void processBatches(@NotNull IntStream stream, int batchSize, @NotNull ThrowableConsumer<? super TIntHashSet, ? extends VcsException> consumer) throws VcsException {
        if (stream == null) {
            TroveUtil.$$$reportNull$$$0(40);
        }
        if (consumer == null) {
            TroveUtil.$$$reportNull$$$0(41);
        }
        Ref batch = new Ref((Object)new TIntHashSet());
        Ref exception = new Ref();
        stream.forEach(commit -> {
            ((TIntHashSet)batch.get()).add(commit);
            if (((TIntHashSet)batch.get()).size() >= batchSize) {
                try {
                    consumer.consume(batch.get());
                }
                catch (VcsException e) {
                    exception.set((Object)e);
                }
                finally {
                    batch.set((Object)new TIntHashSet());
                }
            }
        });
        if (!((TIntHashSet)batch.get()).isEmpty()) {
            consumer.consume(batch.get());
        }
        if (!exception.isNull()) {
            throw (VcsException)((Object)exception.get());
        }
    }

    @NotNull
    public static TIntHashSet singleton(@NotNull Integer elements) {
        if (elements == null) {
            TroveUtil.$$$reportNull$$$0(42);
        }
        TIntHashSet commits = new TIntHashSet();
        commits.add(elements.intValue());
        TIntHashSet tIntHashSet = commits;
        if (tIntHashSet == null) {
            TroveUtil.$$$reportNull$$$0(43);
        }
        return tIntHashSet;
    }

    public static <T> void add(@NotNull Map<? super T, TIntHashSet> targetMap, @NotNull T key, int value) {
        if (targetMap == null) {
            TroveUtil.$$$reportNull$$$0(44);
        }
        if (key == null) {
            TroveUtil.$$$reportNull$$$0(45);
        }
        TIntHashSet set = targetMap.computeIfAbsent(key, __ -> new TIntHashSet());
        set.add(value);
    }

    public static boolean removeAll(@NotNull TIntHashSet fromWhere, @NotNull TIntHashSet what) {
        if (fromWhere == null) {
            TroveUtil.$$$reportNull$$$0(46);
        }
        if (what == null) {
            TroveUtil.$$$reportNull$$$0(47);
        }
        Ref result2 = new Ref((Object)false);
        what.forEach(it -> {
            if (fromWhere.remove(it)) {
                result2.set((Object)true);
            }
            return true;
        });
        return (Boolean)result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/util/TroveUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "small";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "big";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 26: 
            case 28: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 29: 
            case 32: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMap";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromWhere";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/util/TroveUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "streamValues";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "streamKeys";
                break;
            }
            case 5: 
            case 6: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "map2IntSet";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "group";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "singleton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "streamValues";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 43: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "streamKeys";
                break;
            }
            case 4: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "stream";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "intersectTo";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "map2IntSet";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processBatches";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 39: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

