/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.BinaryPatchWriter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchWriter {
    public static void writePatches(@NotNull Project project, @NotNull Path file, @NotNull Path basePath, @NotNull List<? extends FilePatch> patches, @Nullable CommitContext commitContext) throws IOException {
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PatchWriter.$$$reportNull$$$0(1);
        }
        if (basePath == null) {
            PatchWriter.$$$reportNull$$$0(2);
        }
        if (patches == null) {
            PatchWriter.$$$reportNull$$$0(3);
        }
        PatchWriter.writePatches(project, file, basePath, patches, commitContext, StandardCharsets.UTF_8, false);
    }

    public static void writePatches(@NotNull Project project, @NotNull Path file, @Nullable Path basePath, @NotNull List<? extends FilePatch> patches, @Nullable CommitContext commitContext, @NotNull Charset charset, boolean includeBinaries) throws IOException {
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PatchWriter.$$$reportNull$$$0(5);
        }
        if (patches == null) {
            PatchWriter.$$$reportNull$$$0(6);
        }
        if (charset == null) {
            PatchWriter.$$$reportNull$$$0(7);
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file, new OpenOption[0]), charset);){
            PatchWriter.write(project, writer, basePath, patches, commitContext, includeBinaries);
        }
    }

    private static void write(@NotNull Project project, @NotNull Writer writer, @Nullable Path basePath, @NotNull List<? extends FilePatch> patches, @Nullable CommitContext commitContext, boolean includeBinaries) throws IOException {
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(8);
        }
        if (writer == null) {
            PatchWriter.$$$reportNull$$$0(9);
        }
        if (patches == null) {
            PatchWriter.$$$reportNull$$$0(10);
        }
        String lineSeparator = PatchWriter.shouldUseDefaultSeparator(project) ? "\n" : CodeStyle.getSettings((Project)project).getLineSeparator();
        UnifiedDiffWriter.write(project, basePath, patches, writer, lineSeparator, commitContext, null);
        if (includeBinaries) {
            BinaryPatchWriter.writeBinaries(basePath, ContainerUtil.findAll(patches, BinaryFilePatch.class), writer);
        }
    }

    public static boolean shouldUseDefaultSeparator(@Nullable Project project) {
        if (project == null) {
            return true;
        }
        return ContainerUtil.exists((Object[])ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss(), vcs -> vcs.getType() == VcsType.distributed);
    }

    public static void writeAsPatchToClipboard(@NotNull Project project, @NotNull List<? extends FilePatch> patches, @NotNull Path basePath, @Nullable CommitContext commitContext) throws IOException {
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(11);
        }
        if (patches == null) {
            PatchWriter.$$$reportNull$$$0(12);
        }
        if (basePath == null) {
            PatchWriter.$$$reportNull$$$0(13);
        }
        StringWriter writer = new StringWriter();
        PatchWriter.write(project, writer, basePath, patches, commitContext, true);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(writer.toString()));
    }

    @Deprecated
    @NotNull
    public static VirtualFile calculateBaseForWritingPatch(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
        File commonAncestor;
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(14);
        }
        if (changes == null) {
            PatchWriter.$$$reportNull$$$0(15);
        }
        if ((commonAncestor = ChangesUtil.findCommonAncestor(changes)) == null || ChangesUtil.getAffectedVcses(changes, (Project)project).size() != 1) {
            VirtualFile virtualFile = project.getBaseDir();
            if (virtualFile == null) {
                PatchWriter.$$$reportNull$$$0(16);
            }
            return virtualFile;
        }
        VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)project, (FilePath)VcsUtil.getFilePath((File)commonAncestor));
        VirtualFile virtualFile = vcsRoot == null ? project.getBaseDir() : vcsRoot;
        if (virtualFile == null) {
            PatchWriter.$$$reportNull$$$0(17);
        }
        return virtualFile;
    }

    @NotNull
    public static Path calculateBaseDirForWritingPatch(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
        File commonAncestor;
        if (project == null) {
            PatchWriter.$$$reportNull$$$0(18);
        }
        if (changes == null) {
            PatchWriter.$$$reportNull$$$0(19);
        }
        VirtualFile vcsRoot = (commonAncestor = ChangesUtil.findCommonAncestor(changes)) == null || ChangesUtil.getAffectedVcses(changes, (Project)project).size() != 1 ? null : VcsUtil.getVcsRootFor((Project)project, (FilePath)VcsUtil.getFilePath((File)commonAncestor));
        Path path2 = vcsRoot == null ? ProjectKt.getStateStore((Project)project).getProjectBasePath() : vcsRoot.toNioPath();
        if (path2 == null) {
            PatchWriter.$$$reportNull$$$0(20);
        }
        return path2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/PatchWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/PatchWriter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBaseForWritingPatch";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBaseDirForWritingPatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writePatches";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeAsPatchToClipboard";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calculateBaseForWritingPatch";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calculateBaseDirForWritingPatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

