/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImplKt;
import com.intellij.openapi.vcs.changes.VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0;
import com.intellij.openapi.vcs.changes.ignore.lang.IgnoreFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ignoreRefreshQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getIgnoreRefreshQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "findIgnoreFileType", "Lcom/intellij/openapi/vcs/changes/ignore/lang/IgnoreFileType;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "getDirectoryVcsIgnoredStatus", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "dirPathString", "", "isDirectoryVcsIgnored", "", "dirPath", "isPotentiallyIgnoredFile", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isRunConfigurationVcsIgnored", "configurationName", "removeRunConfigurationFromVcsIgnore", "", "Companion", "intellij.platform.vcs.impl"})
public final class VcsIgnoreManagerImpl
implements VcsIgnoreManager {
    @NotNull
    private final MergingUpdateQueue ignoreRefreshQueue;
    private final Project project;
    @NotNull
    private static final ExtensionPointName<VcsIgnoreChecker> EP_NAME;
    public static final Companion Companion;

    @NotNull
    public final MergingUpdateQueue getIgnoreRefreshQueue() {
        return this.ignoreRefreshQueue;
    }

    @Nullable
    public final IgnoreFileType findIgnoreFileType(@NotNull AbstractVcs vcs) {
        Intrinsics.checkNotNullParameter((Object)vcs, (String)"vcs");
        IgnoredFileContentProvider ignoredFileContentProvider = VcsImplUtil.findIgnoredFileContentProvider(vcs);
        if (ignoredFileContentProvider == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ignoredFileContentProvider, (String)"findIgnoredFileContentProvider(vcs) ?: return null");
        IgnoredFileContentProvider ignoredFileContentProvider2 = ignoredFileContentProvider;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(ignoredFileContentProvider2.getFileName());
        if (!(fileType instanceof IgnoreFileType)) {
            fileType = null;
        }
        return (IgnoreFileType)fileType;
    }

    public boolean isDirectoryVcsIgnored(@NotNull String dirPath) {
        Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
        try {
            Function0 checkForIgnore2;
            Function0 function0 = checkForIgnore2 = (Function0)new Function0<Boolean>(this, dirPath){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $dirPath;

                public final boolean invoke() {
                    return VcsIgnoreManagerImpl.access$getDirectoryVcsIgnoredStatus(this.this$0, VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$dirPath) instanceof Ignored;
                }
                {
                    this.this$0 = vcsIgnoreManagerImpl;
                    this.$dirPath = string;
                    super(0);
                }
            };
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0(function0), VcsBundle.message((String)"checking.vcs.status.progress", (Object[])new Object[0]), false, this.project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ProgressManager.getInsta\u2026          false, project)");
            return (Boolean)object;
        }
        catch (IOException e) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)e);
            return false;
        }
    }

    private final IgnoredCheckResult getDirectoryVcsIgnoredStatus(Project project, String dirPathString) {
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePath(dirPathString, true);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsContextFactory.SERVIC\u2026Path(dirPathString, true)");
        FilePath dirPath = filePath;
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)project, (FilePath)dirPath);
        if (virtualFile == null) {
            return (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VcsUtil.getVcsRootFor(pr\u2026ath) ?: return NotIgnored");
        VirtualFile vcsRoot = virtualFile;
        VcsIgnoreChecker vcsIgnoreChecker = VcsIgnoreManagerImplKt.access$getCheckerForFile(project, dirPath);
        if (vcsIgnoreChecker == null || (vcsIgnoreChecker = vcsIgnoreChecker.isFilePatternIgnored(vcsRoot, dirPathString)) == null) {
            vcsIgnoreChecker = (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        return vcsIgnoreChecker;
    }

    public boolean isRunConfigurationVcsIgnored(@NotNull String configurationName) {
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        try {
            Function0 checkForIgnore2;
            String configurationFileName = VcsIgnoreManagerImplKt.access$configurationNameToFileName(configurationName);
            Function0 function0 = checkForIgnore2 = (Function0)new Function0<Boolean>(this, configurationFileName){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $configurationFileName;

                public final boolean invoke() {
                    return VcsIgnoreManagerImplKt.access$checkConfigurationVcsIgnored(VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$configurationFileName) instanceof Ignored;
                }
                {
                    this.this$0 = vcsIgnoreManagerImpl;
                    this.$configurationFileName = string;
                    super(0);
                }
            };
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0(function0), VcsBundle.message((String)"changes.checking.configuration.0.for.ignore", (Object[])new Object[]{configurationName}), false, this.project);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ProgressManager.getInsta\u2026          false, project)");
            return (Boolean)object;
        }
        catch (IOException e) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)e);
            return false;
        }
    }

    public void removeRunConfigurationFromVcsIgnore(@NotNull String configurationName) {
        Intrinsics.checkNotNullParameter((Object)configurationName, (String)"configurationName");
        try {
            Function0 removeFromIgnore2;
            Function0 function0 = removeFromIgnore2 = (Function0)new Function0<Unit>(this, configurationName){
                final /* synthetic */ VcsIgnoreManagerImpl this$0;
                final /* synthetic */ String $configurationName;

                public final void invoke() {
                    VcsIgnoreManagerImplKt.access$removeConfigurationFromVcsIgnore(VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$configurationName);
                }
                {
                    this.this$0 = vcsIgnoreManagerImpl;
                    this.$configurationName = string;
                    super(0);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new VcsIgnoreManagerImplKt$sam$com_intellij_openapi_util_ThrowableComputable$0(function0), VcsBundle.message((String)"changes.removing.configuration.0.from.ignore", (Object[])new Object[]{configurationName}), false, this.project);
        }
        catch (IOException io) {
            VcsIgnoreManagerImplKt.access$getLOG$p().warn((Throwable)io);
        }
    }

    public boolean isPotentiallyIgnoredFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(file)");
        return this.isPotentiallyIgnoredFile(filePath);
    }

    public boolean isPotentiallyIgnoredFile(@NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        boolean $i$f$runReadAction = false;
        return (Boolean)ApplicationManager.getApplication().runReadAction(new Computable<T>(this, filePath){
            final /* synthetic */ VcsIgnoreManagerImpl this$0;
            final /* synthetic */ FilePath $filePath$inlined;
            {
                this.this$0 = vcsIgnoreManagerImpl;
                this.$filePath$inlined = filePath;
            }

            public final T compute() {
                boolean bl;
                block5: {
                    boolean bl2 = false;
                    if (VcsIgnoreManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                        bl = false;
                    } else {
                        ExtensionPointName extensionPointName = IgnoredFileProvider.IGNORE_FILE;
                        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"IgnoredFileProvider.IGNORE_FILE");
                        List list = extensionPointName.getExtensionList();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"IgnoredFileProvider.IGNORE_FILE.extensionList");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                IgnoredFileProvider it = (IgnoredFileProvider)element$iv;
                                boolean bl3 = false;
                                if (!it.isIgnoredFile(VcsIgnoreManagerImpl.access$getProject$p(this.this$0), this.$filePath$inlined)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                }
                return (T)Boolean.valueOf(bl);
            }
        });
    }

    public VcsIgnoreManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        VcsIgnoreManagerImplKt.access$checkProjectNotDefault(this.project);
        this.ignoreRefreshQueue = new MergingUpdateQueue("VcsIgnoreUpdate", 500, true, null, (Disposable)this.project, null, Alarm.ThreadToUse.POOLED_THREAD);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            this.project.getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosing(@NotNull Project closedProject) {
                    Intrinsics.checkNotNullParameter((Object)closedProject, (String)"closedProject");
                    if (project == closedProject) {
                        try {
                            this.getIgnoreRefreshQueue().waitForAllExecuted(10L, TimeUnit.SECONDS);
                        }
                        catch (RuntimeException e) {
                            VcsIgnoreManagerImplKt.access$getLOG$p().warn("Queue '" + this.getIgnoreRefreshQueue() + "' wait for all executed failed with error:", (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        EP_NAME = new ExtensionPointName("com.intellij.vcsIgnoreChecker");
    }

    public static final /* synthetic */ IgnoredCheckResult access$getDirectoryVcsIgnoredStatus(VcsIgnoreManagerImpl $this, Project project, String dirPathString) {
        return $this.getDirectoryVcsIgnoredStatus(project, dirPathString);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getInstanceImpl", "Lcom/intellij/openapi/vcs/changes/VcsIgnoreManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @NotNull
        public final VcsIgnoreManagerImpl getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            VcsIgnoreManager vcsIgnoreManager = VcsIgnoreManager.getInstance((Project)project);
            if (vcsIgnoreManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vcs.changes.VcsIgnoreManagerImpl");
            }
            return (VcsIgnoreManagerImpl)vcsIgnoreManager;
        }

        @NotNull
        public final ExtensionPointName<VcsIgnoreChecker> getEP_NAME() {
            return EP_NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

