/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.conversion.ConverterProvider;
import com.intellij.conversion.impl.ConversionContextImpl;
import com.intellij.conversion.impl.ConversionRunner;
import com.intellij.conversion.impl.ProjectConversionUtil;
import com.intellij.conversion.impl.ui.ConvertProjectDialog;
import com.intellij.ide.IdeBundle;
import com.intellij.impl.ConversionResultImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.project.ProjectStoreOwner;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConversionServiceImpl
extends ConversionService {
    private static final Logger LOG = Logger.getInstance(ConversionServiceImpl.class);

    @NotNull
    public ConversionResult convertSilently(@NotNull Path projectPath, @NotNull ConversionListener listener2) {
        HashSet affectedFiles2;
        List<ConversionRunner> runners;
        ConversionContextImpl context;
        block12: {
            block11: {
                if (projectPath == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(0);
                }
                if (listener2 == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(1);
                }
                context = new ConversionContextImpl(projectPath);
                runners = ConversionServiceImpl.isConversionNeeded(context);
                if (!runners.isEmpty()) break block11;
                ConversionResultImpl conversionResultImpl = ConversionResultImpl.CONVERSION_NOT_NEEDED;
                if (conversionResultImpl == null) {
                    ConversionServiceImpl.$$$reportNull$$$0(2);
                }
                return conversionResultImpl;
            }
            listener2.conversionNeeded();
            affectedFiles2 = new HashSet();
            for (ConversionRunner runner : runners) {
                runner.collectAffectedFiles(affectedFiles2);
            }
            List readOnlyFiles = ConversionRunner.getReadOnlyFiles(affectedFiles2);
            if (readOnlyFiles.isEmpty()) break block12;
            listener2.cannotWriteToFiles(readOnlyFiles);
            ConversionResultImpl conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
            if (conversionResultImpl == null) {
                ConversionServiceImpl.$$$reportNull$$$0(3);
            }
            return conversionResultImpl;
        }
        try {
            Path backupDir = ProjectConversionUtil.backupFiles(affectedFiles2, (Path)context.getProjectBaseDir());
            for (ConversionRunner runner : runners) {
                if (!runner.isConversionNeeded()) continue;
                runner.preProcess();
                runner.process();
                runner.postProcess();
            }
            context.saveFiles(affectedFiles2);
            listener2.successfullyConverted(backupDir);
            context.saveConversionResult();
            return new ConversionResultImpl(runners);
        }
        catch (CannotConvertException | IOException e) {
            listener2.error(e.getMessage());
            ConversionResultImpl conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
            if (conversionResultImpl == null) {
                ConversionServiceImpl.$$$reportNull$$$0(4);
            }
            return conversionResultImpl;
        }
    }

    @NotNull
    public ConversionResult convert(@NotNull Path projectPath) throws CannotConvertException {
        if (projectPath == null) {
            ConversionServiceImpl.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || !ConverterProvider.EP_NAME.hasAnyExtensions() || !Files.exists(projectPath, new LinkOption[0])) {
            ConversionResultImpl conversionResultImpl = ConversionResultImpl.CONVERSION_NOT_NEEDED;
            if (conversionResultImpl == null) {
                ConversionServiceImpl.$$$reportNull$$$0(6);
            }
            return conversionResultImpl;
        }
        ConversionContextImpl context = new ConversionContextImpl(projectPath);
        List<ConversionRunner> converters = ConversionServiceImpl.isConversionNeeded(context);
        if (converters.isEmpty()) {
            ConversionResultImpl conversionResultImpl = ConversionResultImpl.CONVERSION_NOT_NEEDED;
            if (conversionResultImpl == null) {
                ConversionServiceImpl.$$$reportNull$$$0(7);
            }
            return conversionResultImpl;
        }
        Ref ref = new Ref((Object)ConversionResultImpl.CONVERSION_CANCELED);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            ConvertProjectDialog dialog = new ConvertProjectDialog(context, converters);
            dialog.show();
            if (dialog.isConverted()) {
                ref.set((Object)new ConversionResultImpl(converters));
            }
        });
        if (!ref.isNull()) {
            try {
                context.saveConversionResult();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        ConversionResult conversionResult = (ConversionResult)ref.get();
        if (conversionResult == null) {
            ConversionServiceImpl.$$$reportNull$$$0(8);
        }
        return conversionResult;
    }

    @NotNull
    private static List<ConversionRunner> isConversionNeeded(@NotNull ConversionContextImpl context) {
        ArrayList<ConversionRunner> arrayList;
        if (context == null) {
            ConversionServiceImpl.$$$reportNull$$$0(9);
        }
        try {
            Set performedConversionIds;
            Object2LongMap oldMap = context.getProjectFileTimestamps();
            boolean changed = false;
            if (oldMap.isEmpty()) {
                LOG.debug("conversion will be performed because no information about project files");
            } else {
                Object2LongMap newMap = context.getAllProjectFiles();
                LOG.debug("Checking project files");
                ObjectIterator iterator = Object2LongMaps.fastIterator((Object2LongMap)newMap);
                while (iterator.hasNext()) {
                    Object2LongMap.Entry entry = (Object2LongMap.Entry)iterator.next();
                    String path2 = (String)entry.getKey();
                    long oldValue = oldMap.getLong((Object)path2);
                    long newValue = entry.getLongValue();
                    if (newValue == oldValue) continue;
                    LOG.info("conversion will be performed because at least " + path2 + " is changed (oldLastModified=" + oldValue + ", newLastModified=" + newValue + ")");
                    changed = true;
                    break;
                }
            }
            if (changed) {
                performedConversionIds = Collections.emptySet();
            } else {
                performedConversionIds = context.getAppliedConverters();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Project files are up to date. Applied converters: " + performedConversionIds);
                }
            }
            ArrayList<ConversionRunner> runners = new ArrayList<ConversionRunner>();
            ExtensionPointImpl point = (ExtensionPointImpl)ConverterProvider.EP_NAME.getPoint();
            point.processIdentifiableImplementations((supplier, id) -> {
                ConversionRunner runner;
                String providerId = ConversionServiceImpl.getProviderId(supplier, id);
                if (!performedConversionIds.contains(providerId) && (runner = new ConversionRunner(providerId, (ConverterProvider)supplier.get(), context)).isConversionNeeded()) {
                    runners.add(runner);
                }
            });
            arrayList = runners;
        }
        catch (CannotConvertException e) {
            LOG.info("Cannot check whether conversion of project files is needed or not, conversion won't be performed", (Throwable)e);
            List<ConversionRunner> list = Collections.emptyList();
            if (list == null) {
                ConversionServiceImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (arrayList == null) {
            ConversionServiceImpl.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static String getProviderId(@NotNull Supplier<ConverterProvider> supplier, @Nullable String id) {
        if (supplier == null) {
            ConversionServiceImpl.$$$reportNull$$$0(12);
        }
        String string = id == null ? supplier.get().getDeprecatedId() : id;
        if (string == null) {
            ConversionServiceImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void saveConversionResult(@NotNull Path projectPath) {
        if (projectPath == null) {
            ConversionServiceImpl.$$$reportNull$$$0(14);
        }
        try {
            new ConversionContextImpl(projectPath).saveConversionResult();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    public ConversionResult convertModule(@NotNull Project project, @NotNull Path moduleFile) {
        if (project == null) {
            ConversionServiceImpl.$$$reportNull$$$0(15);
        }
        if (moduleFile == null) {
            ConversionServiceImpl.$$$reportNull$$$0(16);
        }
        ConversionContextImpl context = new ConversionContextImpl(((ProjectStoreOwner)project).getComponentStore().getProjectFilePath());
        ArrayList<ConversionRunner> runners = new ArrayList<ConversionRunner>();
        try {
            ExtensionPointImpl point = (ExtensionPointImpl)ConverterProvider.EP_NAME.getPoint();
            point.processIdentifiableImplementations((supplier, id) -> {
                ConversionRunner runner = new ConversionRunner(ConversionServiceImpl.getProviderId(supplier, id), (ConverterProvider)supplier.get(), context);
                if (runner.isModuleConversionNeeded(moduleFile)) {
                    runners.add(runner);
                }
            });
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
        }
        if (runners.isEmpty()) {
            ConversionResultImpl conversionResultImpl = ConversionResultImpl.CONVERSION_NOT_NEEDED;
            if (conversionResultImpl == null) {
                ConversionServiceImpl.$$$reportNull$$$0(17);
            }
            return conversionResultImpl;
        }
        int answer = Messages.showYesNoDialog((Project)project, (String)IdeBundle.message((String)"message.module.file.has.an.older.format.do.you.want.to.convert.it", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            ConversionResultImpl conversionResultImpl = ConversionResultImpl.CONVERSION_CANCELED;
            if (conversionResultImpl == null) {
                ConversionServiceImpl.$$$reportNull$$$0(18);
            }
            return conversionResultImpl;
        }
        if (!Files.isWritable(moduleFile)) {
            Messages.showErrorDialog((Project)project, (String)IdeBundle.message((String)"error.message.cannot.modify.file.0", (Object[])new Object[]{moduleFile.toAbsolutePath().toString()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
            ConversionResultImpl conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
            if (conversionResultImpl == null) {
                ConversionServiceImpl.$$$reportNull$$$0(19);
            }
            return conversionResultImpl;
        }
        try {
            File backupFile = ProjectConversionUtil.backupFile((Path)moduleFile);
            for (ConversionRunner runner : runners) {
                runner.convertModule(moduleFile);
            }
            context.saveFiles(Collections.singletonList(moduleFile));
            Messages.showInfoMessage((Project)project, (String)IdeBundle.message((String)"message.your.module.was.successfully.converted.br.old.version.was.saved.to.0", (Object[])new Object[]{backupFile.getAbsolutePath()}), (String)IdeBundle.message((String)"dialog.title.convert.module", (Object[])new Object[0]));
            return new ConversionResultImpl(runners);
        }
        catch (CannotConvertException e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)VcsBundle.message((String)"dialog.title.cannot.convert.module", (Object[])new Object[0]));
            ConversionResultImpl conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
            if (conversionResultImpl == null) {
                ConversionServiceImpl.$$$reportNull$$$0(20);
            }
            return conversionResultImpl;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ConversionResultImpl conversionResultImpl = ConversionResultImpl.ERROR_OCCURRED;
            if (conversionResultImpl == null) {
                ConversionServiceImpl.$$$reportNull$$$0(21);
            }
            return conversionResultImpl;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/impl/ConversionServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/impl/ConversionServiceImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSilently";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "isConversionNeeded";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderId";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "convertModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertSilently";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isConversionNeeded";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProviderId";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveConversionResult";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convertModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

