/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.psi.PsiModifierList;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;

public final class VisibilityIcons {
    private VisibilityIcons() {
    }

    public static void setVisibilityIcon(PsiModifierList modifierList, RowIcon baseIcon) {
        if (modifierList != null) {
            if (modifierList.hasModifierProperty("public")) {
                VisibilityIcons.setVisibilityIcon(4, baseIcon);
            } else if (modifierList.hasModifierProperty("private")) {
                VisibilityIcons.setVisibilityIcon(1, baseIcon);
            } else if (modifierList.hasModifierProperty("protected")) {
                VisibilityIcons.setVisibilityIcon(3, baseIcon);
            } else if (modifierList.hasModifierProperty("packageLocal")) {
                VisibilityIcons.setVisibilityIcon(2, baseIcon);
            } else {
                Icon emptyIcon = IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON);
                baseIcon.setIcon(emptyIcon, 1);
            }
        } else if (PlatformIcons.PUBLIC_ICON != null) {
            Icon emptyIcon = IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON);
            baseIcon.setIcon(emptyIcon, 1);
        }
    }

    public static void setVisibilityIcon(int accessLevel, RowIcon baseIcon) {
        Icon icon;
        switch (accessLevel) {
            case 4: {
                icon = PlatformIcons.PUBLIC_ICON;
                break;
            }
            case 3: {
                icon = PlatformIcons.PROTECTED_ICON;
                break;
            }
            case 2: {
                icon = PlatformIcons.PACKAGE_LOCAL_ICON;
                break;
            }
            case 1: {
                icon = PlatformIcons.PRIVATE_ICON;
                break;
            }
            default: {
                if (PlatformIcons.PUBLIC_ICON != null) {
                    icon = IconManager.getInstance().createEmptyIcon(PlatformIcons.PUBLIC_ICON);
                    break;
                }
                return;
            }
        }
        baseIcon.setIcon(icon, 1);
    }
}

