/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassCastExceptionInfo
extends ExceptionInfo {
    private static final Pattern CCE_MESSAGE = Pattern.compile("(?:class )?(\\S+) cannot be cast to (?:class )?(\\S+)(?: \\(.+\\))?");
    @Nullable
    private final String myTargetClass;
    @Nullable
    private final String myActualClass;

    ClassCastExceptionInfo(int offset, @NotNull String exceptionMessage) {
        if (exceptionMessage == null) {
            ClassCastExceptionInfo.$$$reportNull$$$0(0);
        }
        super(offset, "java.lang.ClassCastException", exceptionMessage);
        Matcher matcher = CCE_MESSAGE.matcher(exceptionMessage);
        if (matcher.matches()) {
            this.myTargetClass = matcher.group(2);
            this.myActualClass = matcher.group(1);
        } else {
            this.myTargetClass = null;
            this.myActualClass = null;
        }
    }

    @Nullable
    public String getActualClass() {
        return this.myActualClass;
    }

    @Override
    PsiElement matchSpecificExceptionElement(@NotNull PsiElement e) {
        if (e == null) {
            ClassCastExceptionInfo.$$$reportNull$$$0(1);
        }
        if (this.myTargetClass == null) {
            return null;
        }
        if (e instanceof PsiJavaToken && e.textMatches((CharSequence)"(") && e.getParent() instanceof PsiTypeCastExpression) {
            PsiTypeElement typeElement = ((PsiTypeCastExpression)e.getParent()).getCastType();
            if (typeElement == null) {
                return null;
            }
            if (ClassCastExceptionInfo.castClassMatches(typeElement.getType(), this.myTargetClass)) {
                return typeElement;
            }
        }
        if (e instanceof PsiIdentifier && e.getParent() instanceof PsiReferenceExpression) {
            PsiType type;
            PsiReferenceExpression ref = (PsiReferenceExpression)e.getParent();
            PsiElement target = ref.resolve();
            if (target instanceof PsiMethod) {
                type = ((PsiMethod)target).getReturnType();
            } else if (target instanceof PsiVariable) {
                type = ((PsiVariable)target).getType();
            } else {
                return null;
            }
            PsiClass psiClass = PsiUtil.resolveClassInType(type);
            if (!(psiClass instanceof PsiTypeParameter)) {
                return null;
            }
            if (ClassCastExceptionInfo.castClassMatches(ref.getType(), this.myTargetClass)) {
                return e;
            }
        }
        return null;
    }

    private static boolean castClassMatches(PsiType type, String className) {
        if (type instanceof PsiPrimitiveType) {
            return className.equals(((PsiPrimitiveType)type).getBoxedTypeName());
        }
        if (type instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type).getConjuncts()) {
                if (!ClassCastExceptionInfo.castClassMatches(conjunct, className)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof PsiArrayType && className.startsWith("[") && className.length() > 1) {
            PsiType componentType = ((PsiArrayType)type).getComponentType();
            char descriptorChar = className.charAt(1);
            PsiPrimitiveType expected = PsiPrimitiveType.fromJvmTypeDescriptor(descriptorChar);
            if (expected != null) {
                return componentType.equals(expected);
            }
            if (descriptorChar == '[') {
                return ClassCastExceptionInfo.castClassMatches(componentType, className.substring(1));
            }
            if (descriptorChar == 'L' && className.charAt(className.length() - 1) == ';') {
                return ClassCastExceptionInfo.castClassMatches(componentType, className.substring(2, className.length() - 1));
            }
            return false;
        }
        if (type instanceof PsiClassType) {
            return ClassCastExceptionInfo.classTypeMatches(className, (PsiClassType)type, (Set<PsiClass>)new THashSet());
        }
        return true;
    }

    private static boolean classTypeMatches(String className, PsiClassType classType, Set<PsiClass> visited) {
        PsiClass psiClass = PsiUtil.resolveClassInType(classType);
        if (psiClass instanceof PsiTypeParameter) {
            if (!visited.add(psiClass)) {
                return true;
            }
            for (PsiClassType bound : ((PsiTypeParameter)psiClass).getExtendsList().getReferencedTypes()) {
                if (!ClassCastExceptionInfo.classTypeMatches(className, bound, visited)) continue;
                return true;
            }
            return className.equals("java.lang.Object");
        }
        String name = classType.getClassName();
        if (name == null) {
            return true;
        }
        if (!name.equals(StringUtil.substringAfterLast((String)className, (String)".")) && !name.equals(StringUtil.substringAfterLast((String)className, (String)"$"))) {
            return false;
        }
        if (psiClass != null) {
            if (className.equals(psiClass.getQualifiedName())) {
                return true;
            }
            String packageName = StringUtil.getPackageName((String)className);
            PsiFile psiFile = psiClass.getContainingFile();
            return psiFile instanceof PsiClassOwner && packageName.equals(((PsiClassOwner)psiFile).getPackageName());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionMessage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/filters/ClassCastExceptionInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "matchSpecificExceptionElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

