/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import gnu.trove.THashSet;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterInterface;
import org.jetbrains.idea.maven.importing.MavenSourceFoldersModuleExtension;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Path;
import org.jetbrains.idea.maven.utils.Url;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MavenRootModelAdapterLegacyImpl
implements MavenRootModelAdapterInterface {
    private final MavenProject myMavenProject;
    private final ModifiableModuleModel myModuleModel;
    private final ModifiableRootModel myRootModel;
    private final MavenSourceFoldersModuleExtension myRootModelModuleExtension;
    private final Set<String> myOrderEntriesBeforeJdk;

    public MavenRootModelAdapterLegacyImpl(@NotNull MavenProject p, @NotNull Module module, IdeModifiableModelsProvider rootModelsProvider) {
        if (p == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(1);
        }
        this.myOrderEntriesBeforeJdk = new THashSet();
        this.myMavenProject = p;
        this.myModuleModel = rootModelsProvider.getModifiableModuleModel();
        this.myRootModel = rootModelsProvider.getModifiableRootModel(module);
        this.myRootModelModuleExtension = (MavenSourceFoldersModuleExtension)((Object)this.myRootModel.getModuleExtension(MavenSourceFoldersModuleExtension.class));
        this.myRootModelModuleExtension.init(module, this.myRootModel);
    }

    @Override
    public void init(boolean isNewlyCreatedModule) {
        this.setupInitialValues(isNewlyCreatedModule);
        this.initContentRoots();
        this.initOrderEntries();
    }

    private void setupInitialValues(boolean newlyCreatedModule) {
        if (newlyCreatedModule || this.myRootModel.getSdk() == null) {
            this.myRootModel.inheritSdk();
        }
        if (newlyCreatedModule) {
            this.getCompilerExtension().setExcludeOutput(true);
        }
    }

    private void initContentRoots() {
        Url url = this.toUrl(this.myMavenProject.getDirectory());
        if (this.getContentRootFor(url) != null) {
            return;
        }
        this.myRootModel.addContentEntry(url.getUrl());
    }

    private ContentEntry getContentRootFor(Url url) {
        for (ContentEntry e : this.myRootModel.getContentEntries()) {
            if (!VfsUtilCore.isEqualOrAncestor((String)e.getUrl(), (String)url.getUrl())) continue;
            return e;
        }
        return null;
    }

    private void initOrderEntries() {
        boolean jdkProcessed = false;
        for (OrderEntry e : this.myRootModel.getOrderEntries()) {
            Module m;
            if (e instanceof ModuleSourceOrderEntry || e instanceof JdkOrderEntry) {
                jdkProcessed = true;
                continue;
            }
            if (e instanceof LibraryOrderEntry && (!Registry.is((String)"maven.always.remove.bad.entries") ? !MavenRootModelAdapterLegacyImpl.isMavenLibrary(((LibraryOrderEntry)e).getLibrary()) : !MavenRootModelAdapterLegacyImpl.isMavenLibrary((LibraryOrderEntry)e))) continue;
            if (e instanceof ModuleOrderEntry && (m = ((ModuleOrderEntry)e).getModule()) != null && !MavenProjectsManager.getInstance(this.myRootModel.getProject()).isMavenizedModule(m) && ExternalSystemModulePropertyManager.getInstance((Module)m).getExternalSystemId() == null) continue;
            if (!jdkProcessed) {
                if (e instanceof ModuleOrderEntry) {
                    this.myOrderEntriesBeforeJdk.add(((ModuleOrderEntry)e).getModuleName());
                } else if (e instanceof LibraryOrderEntry) {
                    this.myOrderEntriesBeforeJdk.add(((LibraryOrderEntry)e).getLibraryName());
                }
            }
            this.myRootModel.removeOrderEntry(e);
        }
    }

    @Override
    public ModifiableRootModel getRootModel() {
        return this.myRootModel;
    }

    @Override
    public String @NotNull [] getSourceRootUrls(boolean includingTests) {
        String[] stringArray = this.myRootModelModuleExtension.getSourceRootUrls(includingTests);
        if (stringArray == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @Override
    public Module getModule() {
        return this.myRootModel.getModule();
    }

    @Override
    public void clearSourceFolders() {
        this.myRootModelModuleExtension.clearSourceFolders();
    }

    @Override
    public <P extends JpsElement> void addSourceFolder(String path, JpsModuleSourceRootType<P> rootType) {
        this.addSourceFolder(path, rootType, false, (JpsElement)rootType.createDefaultProperties());
    }

    @Override
    public void addGeneratedJavaSourceFolder(String path, JavaSourceRootType rootType, boolean ifNotEmpty) {
        this.addSourceFolder(path, (JpsModuleSourceRootType)rootType, ifNotEmpty, (JpsElement)JpsJavaExtensionService.getInstance().createSourceRootProperties("", true));
    }

    @Override
    public void addGeneratedJavaSourceFolder(String path, JavaSourceRootType rootType) {
        this.addGeneratedJavaSourceFolder(path, rootType, true);
    }

    private <P extends JpsElement> void addSourceFolder(@NotNull String path, @NotNull JpsModuleSourceRootType<P> rootType, boolean ifNotEmpty, @NotNull P properties) {
        String[] childs;
        if (path == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(3);
        }
        if (rootType == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(4);
        }
        if (properties == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(5);
        }
        if (ifNotEmpty ? (childs = new File(this.toPath(path).getPath()).list()) == null || childs.length == 0 : !this.exists(path)) {
            return;
        }
        Url url = this.toUrl(path);
        this.myRootModelModuleExtension.addSourceFolder(url, rootType, properties);
    }

    @Override
    public boolean hasRegisteredSourceSubfolder(@NotNull File f) {
        if (f == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(6);
        }
        String url = this.toUrl(f.getPath()).getUrl();
        return this.myRootModelModuleExtension.hasRegisteredSourceSubfolder(url);
    }

    @Override
    @Nullable
    public SourceFolder getSourceFolder(File folder) {
        String url = this.toUrl(folder.getPath()).getUrl();
        return this.myRootModelModuleExtension.getSourceFolder(url);
    }

    @Override
    public boolean isAlreadyExcluded(File f) {
        String url = this.toUrl(f.getPath()).getUrl();
        return VfsUtilCore.isUnder((String)url, Arrays.asList(this.myRootModel.getExcludeRootUrls()));
    }

    private boolean exists(String path) {
        return Files.exists(Paths.get(this.toPath(path).getPath(), new String[0]), new LinkOption[0]);
    }

    @Override
    public void addExcludedFolder(String path) {
        this.unregisterAll(path, true, false);
        Url url = this.toUrl(path);
        ContentEntry e = this.getContentRootFor(url);
        if (e == null) {
            return;
        }
        if (e.getUrl().equals(url.getUrl())) {
            return;
        }
        e.addExcludeFolder(url.getUrl());
    }

    @Override
    public void unregisterAll(String path, boolean under, boolean unregisterSources) {
        Url url = this.toUrl(path);
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            if (unregisterSources) {
                this.myRootModelModuleExtension.unregisterAll(url, under);
            }
            for (String excludedUrl : eachEntry.getExcludeFolderUrls()) {
                String child;
                String ancestor = under ? url.getUrl() : excludedUrl;
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)(child = under ? excludedUrl : url.getUrl()))) continue;
                eachEntry.removeExcludeFolder(excludedUrl);
            }
            for (String outputUrl : this.getCompilerExtension().getOutputRootUrls(true)) {
                String child;
                String ancestor = under ? url.getUrl() : outputUrl;
                String string = child = under ? outputUrl : url.getUrl();
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)child)) continue;
                this.getCompilerExtension().setExcludeOutput(false);
            }
        }
    }

    @Override
    public boolean hasCollision(String sourceRootPath) {
        Url url = this.toUrl(sourceRootPath);
        for (ContentEntry eachEntry : this.myRootModel.getContentEntries()) {
            for (SourceFolder eachFolder : eachEntry.getSourceFolders()) {
                String child;
                String ancestor = url.getUrl();
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)(child = eachFolder.getUrl())) && !VfsUtilCore.isEqualOrAncestor((String)child, (String)ancestor)) continue;
                return true;
            }
            for (String excludeUrl : eachEntry.getExcludeFolderUrls()) {
                String ancestor = url.getUrl();
                if (!VfsUtilCore.isEqualOrAncestor((String)ancestor, (String)excludeUrl) && !VfsUtilCore.isEqualOrAncestor((String)excludeUrl, (String)ancestor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void useModuleOutput(String production, String test) {
        this.getCompilerExtension().inheritCompilerOutputPath(false);
        this.getCompilerExtension().setCompilerOutputPath(this.toUrl(production).getUrl());
        this.getCompilerExtension().setCompilerOutputPathForTests(this.toUrl(test).getUrl());
    }

    private CompilerModuleExtension getCompilerExtension() {
        return (CompilerModuleExtension)this.myRootModel.getModuleExtension(CompilerModuleExtension.class);
    }

    private Url toUrl(String path) {
        return this.toPath(path).toUrl();
    }

    @Override
    public Path toPath(String path) {
        return MavenUtil.toPath(this.myMavenProject, path);
    }

    @Override
    public void addModuleDependency(@NotNull String moduleName, @NotNull DependencyScope scope, boolean testJar) {
        Module m;
        if (moduleName == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(8);
        }
        ModuleOrderEntry e = (m = this.findModuleByName(moduleName)) != null ? this.myRootModel.addModuleOrderEntry(m) : (ModuleOrderEntry)ReadAction.compute(() -> this.myRootModel.addInvalidModuleEntry(moduleName));
        e.setScope(scope);
        if (testJar) {
            e.setProductionOnTestDependency(true);
        }
        if (this.myOrderEntriesBeforeJdk.contains(moduleName)) {
            this.moveLastOrderEntryBeforeJdk();
        }
    }

    @Override
    @Nullable
    public Module findModuleByName(String moduleName) {
        return this.myModuleModel.findModuleByName(moduleName);
    }

    @Override
    public void addSystemDependency(MavenArtifact artifact, DependencyScope scope) {
        assert ("system".equals(artifact.getScope()));
        String libraryName = artifact.getLibraryName();
        Library library = this.myRootModel.getModuleLibraryTable().getLibraryByName(libraryName);
        if (library == null) {
            library = this.myRootModel.getModuleLibraryTable().createLibrary(libraryName);
        }
        LibraryOrderEntry orderEntry = this.myRootModel.findLibraryOrderEntry(library);
        assert (orderEntry != null);
        orderEntry.setScope(scope);
        Library.ModifiableModel modifiableModel = library.getModifiableModel();
        MavenRootModelAdapterLegacyImpl.updateUrl(modifiableModel, OrderRootType.CLASSES, artifact, null, null, true);
        modifiableModel.commit();
        if (this.myOrderEntriesBeforeJdk.contains(libraryName)) {
            this.moveLastOrderEntryBeforeJdk();
        }
    }

    @Override
    public LibraryOrderEntry addLibraryDependency(MavenArtifact artifact, DependencyScope scope, IdeModifiableModelsProvider provider, MavenProject project) {
        assert (!"system".equals(artifact.getScope()));
        String libraryName = artifact.getLibraryName();
        Library library = provider.getLibraryByName(libraryName);
        if (library == null) {
            library = provider.createLibrary(libraryName, MavenRootModelAdapterLegacyImpl.getMavenExternalSource());
        }
        Library.ModifiableModel libraryModel = provider.getModifiableLibraryModel(library);
        MavenRootModelAdapterLegacyImpl.updateUrl(libraryModel, OrderRootType.CLASSES, artifact, null, null, true);
        MavenRootModelAdapterLegacyImpl.updateUrl(libraryModel, OrderRootType.SOURCES, artifact, MavenExtraArtifactType.SOURCES, project, false);
        MavenRootModelAdapterLegacyImpl.updateUrl(libraryModel, JavadocOrderRootType.getInstance(), artifact, MavenExtraArtifactType.DOCS, project, false);
        LibraryOrderEntry e = this.myRootModel.addLibraryEntry(library);
        e.setScope(scope);
        if (this.myOrderEntriesBeforeJdk.contains(libraryName)) {
            this.moveLastOrderEntryBeforeJdk();
        }
        return e;
    }

    private void moveLastOrderEntryBeforeJdk() {
        int i;
        OrderEntry[] entries = (OrderEntry[])this.myRootModel.getOrderEntries().clone();
        for (i = entries.length - 1; i > 0 && (entries[i - 1] instanceof ModuleSourceOrderEntry || entries[i - 1] instanceof JdkOrderEntry); --i) {
            OrderEntry e = entries[i - 1];
            entries[i - 1] = entries[i];
            entries[i] = e;
        }
        if (i < entries.length) {
            this.myRootModel.rearrangeOrderEntries(entries);
        }
    }

    private static void updateUrl(Library.ModifiableModel library, OrderRootType type, MavenArtifact artifact, MavenExtraArtifactType artifactType, MavenProject project, boolean clearAll) {
        String classifier = null;
        String extension = null;
        if (artifactType != null) {
            Pair<String, String> result = project.getClassifierAndExtension(artifact, artifactType);
            classifier = (String)result.first;
            extension = (String)result.second;
        }
        String newPath = artifact.getPathForExtraArtifact(classifier, extension);
        String newUrl = VirtualFileManager.constructUrl((String)"jar", (String)newPath) + "!/";
        boolean urlExists = false;
        for (String url : library.getUrls(type)) {
            if (newUrl.equals(url)) {
                urlExists = true;
                continue;
            }
            if (!clearAll && (!MavenRootModelAdapterLegacyImpl.isRepositoryUrl(artifact, url) || url.startsWith(newUrl))) continue;
            library.removeRoot(url, type);
        }
        if (!urlExists) {
            library.addRoot(newUrl, type);
        }
    }

    private static boolean isRepositoryUrl(MavenArtifact artifact, String url) {
        return url.contains(artifact.getGroupId().replace('.', '/') + "/" + artifact.getArtifactId() + "/" + artifact.getBaseVersion() + "/" + artifact.getArtifactId() + "-");
    }

    @Override
    public Library findLibrary(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(9);
        }
        String name = artifact.getLibraryName();
        Ref result = Ref.create(null);
        this.myRootModel.orderEntries().forEachLibrary(library -> {
            if (name.equals(library.getName())) {
                result.set(library);
            }
            return true;
        });
        return (Library)result.get();
    }

    @Deprecated
    public static String makeLibraryName(@NotNull MavenArtifact artifact) {
        if (artifact == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(10);
        }
        return artifact.getLibraryName();
    }

    public static boolean isMavenLibrary(@Nullable Library library) {
        return library != null && MavenArtifact.isMavenLibrary((String)library.getName());
    }

    public static boolean isMavenLibrary(@Nullable LibraryOrderEntry entry) {
        return entry != null && MavenArtifact.isMavenLibrary((String)entry.getLibraryName());
    }

    public static ProjectModelExternalSource getMavenExternalSource() {
        return ExternalProjectSystemRegistry.getInstance().getSourceById("Maven");
    }

    @Nullable
    public static OrderEntry findLibraryEntry(@NotNull Module m, @NotNull MavenArtifact artifact) {
        if (m == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(11);
        }
        if (artifact == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(12);
        }
        String name = artifact.getLibraryName();
        for (OrderEntry each : ModuleRootManager.getInstance((Module)m).getOrderEntries()) {
            if (!(each instanceof LibraryOrderEntry) || !name.equals(((LibraryOrderEntry)each).getLibraryName())) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public static MavenArtifact findArtifact(@NotNull MavenProject project, @Nullable Library library) {
        if (project == null) {
            MavenRootModelAdapterLegacyImpl.$$$reportNull$$$0(13);
        }
        if (library == null) {
            return null;
        }
        String name = library.getName();
        if (!MavenArtifact.isMavenLibrary((String)name)) {
            return null;
        }
        for (MavenArtifact each : project.getDependencies()) {
            if (!each.getLibraryName().equals(name)) continue;
            return each;
        }
        return null;
    }

    @Override
    public void setLanguageLevel(LanguageLevel level) {
        try {
            ((LanguageLevelModuleExtension)this.myRootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(level);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenRootModelAdapterLegacyImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenRootModelAdapterLegacyImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasRegisteredSourceSubfolder";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addModuleDependency";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "makeLibraryName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryEntry";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findArtifact";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

