/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.completion.insert.MavenDependencyInsertionHandler;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

public abstract class MavenCoordinateCompletionContributor
extends CompletionContributor {
    private final String myTagId;

    protected MavenCoordinateCompletionContributor(String id) {
        this.myTagId = id;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PlaceChecker placeChecker = new PlaceChecker(parameters).checkPlace();
        if (placeChecker.isCorrectPlace()) {
            MavenDomShortArtifactCoordinates coordinates = placeChecker.getCoordinates();
            result = this.amendResultSet(result);
            ConcurrentLinkedDeque<RepositoryArtifactData> cld = new ConcurrentLinkedDeque<RepositoryArtifactData>();
            Promise<Integer> promise = this.find(DependencySearchService.getInstance((Project)placeChecker.getProject()), coordinates, parameters, mdci -> cld.add((RepositoryArtifactData)mdci));
            this.fillResults(result, coordinates, cld, promise);
            this.fillAfter(result);
        }
    }

    protected void fillResults(@NotNull CompletionResultSet result, @NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull ConcurrentLinkedDeque<RepositoryArtifactData> cld, @NotNull Promise<Integer> promise) {
        if (result == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(2);
        }
        if (coordinates == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(3);
        }
        if (cld == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(4);
        }
        if (promise == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(5);
        }
        while (promise.getState() == Promise.State.PENDING || !cld.isEmpty()) {
            ProgressManager.checkCanceled();
            RepositoryArtifactData item = cld.poll();
            if (!(item instanceof MavenRepositoryArtifactInfo)) continue;
            this.fillResult(coordinates, result, (MavenRepositoryArtifactInfo)item);
        }
    }

    protected SearchParameters createSearchParameters(CompletionParameters parameters) {
        return new SearchParameters(parameters.getInvocationCount() < 2, ApplicationManager.getApplication().isUnitTestMode());
    }

    protected abstract Promise<Integer> find(@NotNull DependencySearchService var1, @NotNull MavenDomShortArtifactCoordinates var2, @NotNull CompletionParameters var3, @NotNull Consumer<RepositoryArtifactData> var4);

    protected boolean validate(String groupId, String artifactId) {
        return true;
    }

    protected void fillAfter(CompletionResultSet result) {
    }

    protected void fillResult(@NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull CompletionResultSet result, @NotNull MavenRepositoryArtifactInfo item) {
        if (coordinates == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(6);
        }
        if (result == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(7);
        }
        if (item == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(8);
        }
        result.addElement((LookupElement)MavenDependencyCompletionUtil.lookupElement(item).withInsertHandler(MavenDependencyInsertionHandler.INSTANCE));
    }

    @NotNull
    protected CompletionResultSet amendResultSet(@NotNull CompletionResultSet result) {
        if (result == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(9);
        }
        result.restartCompletionWhenNothingMatches();
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(10);
        }
        return completionResultSet;
    }

    @NotNull
    protected static String trimDummy(@Nullable String value) {
        if (value == null) {
            return "";
        }
        String string = StringUtil.trim((String)value.replace("IntellijIdeaRulezzz ", "").replace(CompletionUtil.DUMMY_IDENTIFIER_TRIMMED, ""));
        if (string == null) {
            MavenCoordinateCompletionContributor.$$$reportNull$$$0(11);
        }
        return string;
    }

    protected static <T> Consumer<T> withPredicate(Consumer<T> consumer, Predicate<T> predicate) {
        return it -> {
            if (predicate.test(it)) {
                consumer.accept(it);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cld";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/model/completion/MavenCoordinateCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/model/completion/MavenCoordinateCompletionContributor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "amendResultSet";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "trimDummy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillResults";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillResult";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "amendResultSet";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class PlaceChecker {
        private boolean badPlace;
        private CompletionParameters myParameters;
        private Project myProject;
        private MavenDomShortArtifactCoordinates domCoordinates;

        public PlaceChecker(CompletionParameters parameters) {
            this.myParameters = parameters;
        }

        boolean isCorrectPlace() {
            return !this.badPlace;
        }

        Project getProject() {
            return this.myProject;
        }

        MavenDomShortArtifactCoordinates getCoordinates() {
            return this.domCoordinates;
        }

        public PlaceChecker checkPlace() {
            if (this.myParameters.getCompletionType() != CompletionType.BASIC) {
                this.badPlace = true;
                return this;
            }
            PsiElement element = this.myParameters.getPosition();
            PsiElement xmlText = element.getParent();
            if (!(xmlText instanceof XmlText)) {
                this.badPlace = true;
                return this;
            }
            PsiElement tagElement = xmlText.getParent();
            if (!(tagElement instanceof XmlTag)) {
                this.badPlace = true;
                return this;
            }
            XmlTag tag = (XmlTag)tagElement;
            if (!MavenCoordinateCompletionContributor.this.myTagId.equals(tag.getName())) {
                this.badPlace = true;
                return this;
            }
            this.myProject = element.getProject();
            switch (MavenCoordinateCompletionContributor.this.myTagId) {
                case "artifactId": 
                case "groupId": 
                case "version": {
                    this.checkPlaceForChildrenTags(tag);
                    break;
                }
                case "dependency": 
                case "extension": 
                case "plugin": {
                    this.checkPlaceForParentTags(tag);
                    break;
                }
                default: {
                    this.badPlace = true;
                }
            }
            return this;
        }

        private void checkPlaceForChildrenTags(XmlTag tag) {
            DomElement domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag);
            if (!(domElement instanceof GenericDomValue)) {
                this.badPlace = true;
                return;
            }
            DomElement parent = domElement.getParent();
            if (parent instanceof MavenDomShortArtifactCoordinates) {
                this.domCoordinates = (MavenDomShortArtifactCoordinates)parent;
            } else {
                this.badPlace = true;
            }
        }

        private void checkPlaceForParentTags(XmlTag tag) {
            DomElement domElement = DomManager.getDomManager((Project)this.myProject).getDomElement(tag);
            if (domElement instanceof MavenDomShortArtifactCoordinates) {
                this.domCoordinates = (MavenDomShortArtifactCoordinates)domElement;
            } else {
                this.badPlace = true;
            }
        }
    }
}

