/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.model.MavenArtifact;

public class DependencyConflictId {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;

    public DependencyConflictId(@NotNull String groupId, @NotNull String artifactId, @Nullable String type, @Nullable String classifier) {
        if (groupId == null) {
            DependencyConflictId.$$$reportNull$$$0(0);
        }
        if (artifactId == null) {
            DependencyConflictId.$$$reportNull$$$0(1);
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = StringUtil.isEmpty((String)type) ? "jar" : type;
        this.classifier = classifier;
    }

    @Nullable
    public static DependencyConflictId create(@NotNull MavenDomDependency dep) {
        String groupId;
        if (dep == null) {
            DependencyConflictId.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(groupId = dep.getGroupId().getStringValue()))) {
            return null;
        }
        String artifactId = dep.getArtifactId().getStringValue();
        if (StringUtil.isEmpty((String)artifactId)) {
            return null;
        }
        return new DependencyConflictId(groupId, artifactId, dep.getType().getStringValue(), dep.getClassifier().getStringValue());
    }

    @Nullable
    public static DependencyConflictId create(@NotNull MavenArtifact dep) {
        if (dep == null) {
            DependencyConflictId.$$$reportNull$$$0(3);
        }
        return DependencyConflictId.create(dep.getGroupId(), dep.getArtifactId(), dep.getType(), dep.getClassifier());
    }

    @Nullable
    public static DependencyConflictId create(String groupId, String artifactId, String type, String classifier) {
        if (StringUtil.isEmpty((String)groupId)) {
            return null;
        }
        if (StringUtil.isEmpty((String)artifactId)) {
            return null;
        }
        return new DependencyConflictId(groupId, artifactId, type, classifier);
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            DependencyConflictId.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            DependencyConflictId.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getType() {
        String string = this.type;
        if (string == null) {
            DependencyConflictId.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DependencyConflictId)) {
            return false;
        }
        DependencyConflictId id = (DependencyConflictId)o;
        if (!this.artifactId.equals(id.artifactId)) {
            return false;
        }
        if (this.classifier != null ? !this.classifier.equals(id.classifier) : id.classifier != null) {
            return false;
        }
        if (!this.groupId.equals(id.groupId)) {
            return false;
        }
        return this.type.equals(id.type);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dep";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/DependencyConflictId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/DependencyConflictId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

