/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant.vfs;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestDataUtil;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupFileSystem;

@Presentation(icon="AllIcons.Nodes.TestSourceFolder")
public class TestDataGroupVirtualFile
extends VirtualFile {
    private final VirtualFile myBeforeFile;
    private final VirtualFile myAfterFile;

    public TestDataGroupVirtualFile(@NotNull VirtualFile beforeFile, @NotNull VirtualFile afterFile) {
        if (beforeFile == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(0);
        }
        if (afterFile == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(1);
        }
        this.myBeforeFile = beforeFile;
        this.myAfterFile = afterFile;
    }

    @NotNull
    public String getName() {
        String string = TestDataUtil.getGroupDisplayName(this.myBeforeFile.getName(), this.myAfterFile.getName());
        if (string == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public VirtualFile getBeforeFile() {
        VirtualFile virtualFile = this.myBeforeFile;
        if (virtualFile == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getAfterFile() {
        VirtualFile virtualFile = this.myAfterFile;
        if (virtualFile == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        TestDataGroupFileSystem testDataGroupFileSystem = TestDataGroupFileSystem.getTestDataGroupFileSystem();
        if (testDataGroupFileSystem == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(5);
        }
        return testDataGroupFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = TestDataGroupFileSystem.getPath(this.myBeforeFile, this.myAfterFile);
        if (string == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isWritable() {
        return this.myBeforeFile.isWritable();
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return this.myBeforeFile.isValid() && this.myAfterFile.isValid();
    }

    public VirtualFile getParent() {
        return this.myBeforeFile.getParent();
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(7);
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    public long getTimeStamp() {
        return this.myBeforeFile.getTimeStamp();
    }

    public long getLength() {
        return this.myBeforeFile.getLength();
    }

    public long getModificationStamp() {
        return this.myBeforeFile.getModificationStamp();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myBeforeFile.getFileType();
        if (fileType == null) {
            TestDataGroupVirtualFile.$$$reportNull$$$0(8);
        }
        return fileType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TestDataGroupVirtualFile file = (TestDataGroupVirtualFile)((Object)o);
        if (!this.myAfterFile.equals(file.myAfterFile)) {
            return false;
        }
        return this.myBeforeFile.equals(file.myBeforeFile);
    }

    public int hashCode() {
        int result = this.myBeforeFile.hashCode();
        result = 31 * result + this.myAfterFile.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/vfs/TestDataGroupVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/vfs/TestDataGroupVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

