/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.diagnostic.VMOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.execution.configurations.SimpleConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.run.PluginRunConfiguration;

public final class PluginConfigurationType
extends SimpleConfigurationType {
    @NonNls
    private String myVmParameters = "-Xmx512m -Xms256m -ea";

    public PluginConfigurationType() {
        super("#org.jetbrains.idea.devkit.run.PluginConfigurationType", DevKitBundle.message("run.configuration.title", new Object[0]), DevKitBundle.message("run.configuration.type.description", new Object[0]), NotNullLazyValue.createValue(() -> AllIcons.Nodes.Plugin));
    }

    @NotNull
    public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
        if (project == null) {
            PluginConfigurationType.$$$reportNull$$$0(0);
        }
        PluginRunConfiguration runConfiguration = new PluginRunConfiguration(project, (ConfigurationFactory)this, "");
        runConfiguration.VM_PARAMETERS = runConfiguration.VM_PARAMETERS == null ? this.getVmParameters() : runConfiguration.VM_PARAMETERS + this.getVmParameters();
        PluginRunConfiguration pluginRunConfiguration = runConfiguration;
        if (pluginRunConfiguration == null) {
            PluginConfigurationType.$$$reportNull$$$0(1);
        }
        return pluginRunConfiguration;
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            PluginConfigurationType.$$$reportNull$$$0(2);
        }
        return ModuleUtil.hasModulesOfType((Project)project, (ModuleType)PluginModuleType.getInstance());
    }

    @NotNull
    public RunConfiguration createConfiguration(@Nullable String name, @NotNull RunConfiguration template) {
        PluginRunConfiguration pluginRunConfiguration;
        if (template == null) {
            PluginConfigurationType.$$$reportNull$$$0(3);
        }
        if ((pluginRunConfiguration = (PluginRunConfiguration)template).getModule() == null) {
            Collection modules = ModuleUtil.getModulesOfType((Project)pluginRunConfiguration.getProject(), (ModuleType)PluginModuleType.getInstance());
            pluginRunConfiguration.setModule((Module)ContainerUtil.getFirstItem((Collection)modules));
        }
        RunConfiguration runConfiguration = super.createConfiguration(name, (RunConfiguration)pluginRunConfiguration);
        if (runConfiguration == null) {
            PluginConfigurationType.$$$reportNull$$$0(4);
        }
        return runConfiguration;
    }

    @NotNull
    public String getTag() {
        return "plugin";
    }

    public String getHelpTopic() {
        return "reference.dialogs.rundebug.devkit.PluginConfigurationType";
    }

    @NotNull
    private String getVmParameters() {
        if (this.myVmParameters == null) {
            String vmOptions;
            try {
                vmOptions = FileUtil.loadFile((File)new File(PathManager.getBinPath(), "idea.plugins.vmoptions"));
            }
            catch (IOException e) {
                vmOptions = VMOptions.read();
            }
            this.myVmParameters = vmOptions != null ? vmOptions.replaceAll("\\s+", " ").trim() : "";
        }
        String string = this.myVmParameters;
        if (string == null) {
            PluginConfigurationType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public RunConfigurationSingletonPolicy getSingletonPolicy() {
        RunConfigurationSingletonPolicy runConfigurationSingletonPolicy = RunConfigurationSingletonPolicy.SINGLE_INSTANCE_ONLY;
        if (runConfigurationSingletonPolicy == null) {
            PluginConfigurationType.$$$reportNull$$$0(6);
        }
        return runConfigurationSingletonPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/run/PluginConfigurationType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/run/PluginConfigurationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplateConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVmParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingletonPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateConfiguration";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

