/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.idea.devkit.dom.generator.Emitter;
import org.jetbrains.idea.devkit.dom.generator.FileManager;
import org.jetbrains.idea.devkit.dom.generator.JetBrainsEmitter;
import org.jetbrains.idea.devkit.dom.generator.MergingFileManager;
import org.jetbrains.idea.devkit.dom.generator.ModelDesc;
import org.jetbrains.idea.devkit.dom.generator.ModelLoader;
import org.jetbrains.idea.devkit.dom.generator.NamespaceDesc;
import org.jetbrains.idea.devkit.dom.generator.Util;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModelGen {
    private final ModelDesc model = new ModelDesc();
    private final Map<String, String> schemaLocationMap = new HashMap<String, String>();
    private final ModelLoader loader;
    private final Emitter emitter;
    private final FileManager fileManager;

    public ModelGen(ModelLoader loader) {
        this(loader, new JetBrainsEmitter(), new MergingFileManager());
    }

    public ModelGen(ModelLoader loader, Emitter emitter, FileManager fileManager) {
        this.loader = loader;
        this.emitter = emitter;
        this.fileManager = fileManager;
    }

    public ModelDesc getModel() {
        return this.model;
    }

    public static Element loadXml(File configXml) throws Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new CharArrayReader(new char[0]));
            }
        });
        Document document = saxBuilder.build(configXml);
        return document.getRootElement();
    }

    public void loadConfig(File configXml) throws Exception {
        this.loadConfig(ModelGen.loadXml(configXml));
    }

    public void setConfig(String schema, String location, NamespaceDesc desc, String ... schemasToSkip) {
        this.schemaLocationMap.put(schema, location);
        for (String sch : schemasToSkip) {
            if (sch == null || sch.length() <= 0) continue;
            this.model.nsdMap.put(sch, new NamespaceDesc(sch));
        }
        this.model.nsdMap.put("", new NamespaceDesc("", "", "com.intellij.util.xml.DomElement", "", null, null, null, null));
        this.model.nsdMap.put(desc.name, desc);
    }

    public void loadConfig(Element element) {
        String name;
        Element namespaceEl = element.getChild("namespaces");
        for (Element e : namespaceEl.getChildren("schemaLocation")) {
            name = e.getAttributeValue("name");
            String file = e.getAttributeValue("file");
            this.schemaLocationMap.put(name, file);
        }
        for (Element e : namespaceEl.getChildren("reserved-name")) {
            name = e.getAttributeValue("name");
            String replacement = e.getAttributeValue("replace-with");
            this.model.name2replaceMap.put(name, replacement);
        }
        NamespaceDesc def = new NamespaceDesc("", "generated", "java.lang.Object", "", null, null, null, null);
        for (Element nsElement : namespaceEl.getChildren("namespace")) {
            String name2 = nsElement.getAttributeValue("name");
            NamespaceDesc nsDesc = new NamespaceDesc(name2, def);
            String skip = nsElement.getAttributeValue("skip");
            String prefix = nsElement.getAttributeValue("prefix");
            String superC = nsElement.getAttributeValue("super");
            String imports = nsElement.getAttributeValue("imports");
            String packageS = nsElement.getAttributeValue("package");
            String packageEnumS = nsElement.getAttributeValue("enums");
            String interfaces = nsElement.getAttributeValue("interfaces");
            ArrayList<String> list = new ArrayList<String>();
            for (Element pkgElement : nsElement.getChildren("package")) {
                String pkgName = pkgElement.getAttributeValue("name");
                String fileName = pkgElement.getAttributeValue("file");
                list.add(fileName);
                list.add(pkgName);
            }
            for (Element pkgElement : nsElement.getChildren("property")) {
                String propertyName = pkgElement.getAttributeValue("name");
                String propertyValue = pkgElement.getAttributeValue("value");
                nsDesc.props.put(propertyName, propertyValue);
            }
            if (skip != null) {
                nsDesc.skip = skip.equalsIgnoreCase("true");
            }
            if (prefix != null) {
                nsDesc.prefix = prefix;
            }
            if (superC != null) {
                nsDesc.superClass = superC;
            }
            if (imports != null) {
                nsDesc.imports = imports;
            }
            if (packageS != null) {
                nsDesc.pkgName = packageS;
            }
            if (packageEnumS != null) {
                nsDesc.enumPkg = packageEnumS;
            }
            if (interfaces != null) {
                nsDesc.intfs = interfaces;
            }
            if (!list.isEmpty()) {
                nsDesc.pkgNames = ArrayUtilRt.toStringArray(list);
            }
            if (name2.length() == 0) {
                def = nsDesc;
            }
            this.model.nsdMap.put(name2, nsDesc);
        }
    }

    public void perform(File outputRoot, File ... modelRoots) throws Exception {
        this.loadModel(modelRoots);
        this.emitter.emit(this.fileManager, this.model, outputRoot);
        Util.log("Done.");
    }

    public void loadModel(final File ... modelRoots) throws Exception {
        XMLEntityResolver resolver = new XMLEntityResolver(){

            public XMLInputSource resolveEntity(XMLResourceIdentifier xmlResourceIdentifier) throws XNIException, IOException {
                String esid = xmlResourceIdentifier.getExpandedSystemId();
                if (esid == null) {
                    String location = ModelGen.this.schemaLocationMap.get(xmlResourceIdentifier.getNamespace());
                    if (location != null) {
                        esid = location;
                    } else {
                        return null;
                    }
                }
                File f = null;
                for (File root : modelRoots) {
                    if (root == null) continue;
                    if (root.isDirectory()) {
                        String fileName = esid.substring(esid.lastIndexOf(47) + 1);
                        f = new File(root, fileName);
                        continue;
                    }
                    f = root;
                }
                if (f == null || !f.exists()) {
                    Util.logerr("unable to resolve: " + esid);
                    return null;
                }
                esid = f.getPath();
                return new XMLInputSource(null, esid, null);
            }
        };
        ArrayList<File> files = new ArrayList<File>();
        for (File root : modelRoots) {
            ContainerUtil.addAll(files, (Object[])root.listFiles());
        }
        this.loader.loadModel(this.model, files, resolver);
        Util.log(this.model.jtMap.size() + " java types loaded");
    }
}

