/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.DeleteProvider;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleDeleteProvider
implements DeleteProvider {
    private static final Logger LOG = Logger.getInstance(ResourceBundleDeleteProvider.class);

    public void deleteElement(@NotNull DataContext dataContext) {
        ResourceBundle[] resourceBundles;
        if (dataContext == null) {
            ResourceBundleDeleteProvider.$$$reportNull$$$0(0);
        }
        if ((resourceBundles = (ResourceBundle[])ResourceBundle.ARRAY_DATA_KEY.getData(dataContext)) != null && resourceBundles.length != 0) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            LOG.assertTrue(project != null);
            PsiElement[] toDelete = (PsiElement[])Arrays.stream(resourceBundles).flatMap(rb -> rb.getPropertiesFiles().stream()).map(PropertiesFile::getContainingFile).toArray(PsiElement[]::new);
            SafeDeleteHandler.invoke((Project)project, (PsiElement[])toDelete, (boolean)true, () -> {
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                for (ResourceBundle bundle : resourceBundles) {
                    fileEditorManager.closeFile((VirtualFile)new ResourceBundleAsVirtualFile(bundle));
                }
            });
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            ResourceBundleDeleteProvider.$$$reportNull$$$0(1);
        }
        return (project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dataContext";
        objectArray2[1] = "com/intellij/lang/properties/projectView/ResourceBundleDeleteProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

