/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.EmptyIcon;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PropertiesGroupingStructureViewComponent
extends StructureViewComponent {
    protected PropertiesGroupingStructureViewComponent(Project project, FileEditor editor, PropertiesGroupingStructureViewModel structureViewModel) {
        super(editor, (StructureViewModel)structureViewModel, project, true);
        this.showToolbar();
    }

    public void setActionActive(String name, boolean state) {
        if ("GROUP_BY_PREFIXES".equals(name)) {
            ((PropertiesGroupingStructureViewModel)this.getTreeModel()).setGroupingActive(state);
        }
        super.setActionActive(name, state);
    }

    protected void addGroupByActions(@NotNull DefaultActionGroup result) {
        if (result == null) {
            PropertiesGroupingStructureViewComponent.$$$reportNull$$$0(0);
        }
        super.addGroupByActions(result);
        result.add((AnAction)new ChangeGroupSeparatorAction());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent", "addGroupByActions"));
    }

    private class ChangeGroupSeparatorAction
    extends DefaultActionGroup {
        private final Set<String> myPredefinedSeparators;

        ChangeGroupSeparatorAction() {
            super(PropertiesBundle.message("group.by.title", new Object[0]), true);
            this.myPredefinedSeparators = new LinkedHashSet<String>();
            this.myPredefinedSeparators.add(".");
            this.myPredefinedSeparators.add("_");
            this.myPredefinedSeparators.add("/");
            this.myPredefinedSeparators.add(this.getCurrentSeparator());
            this.refillActionGroup();
        }

        public final void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChangeGroupSeparatorAction.$$$reportNull$$$0(0);
            }
            String separator = this.getCurrentSeparator();
            Presentation presentation = e.getPresentation();
            presentation.setText(PropertiesBundle.message("group.by.0", separator), false);
            presentation.setIcon(EmptyIcon.ICON_16);
        }

        @NlsSafe
        private String getCurrentSeparator() {
            return ((PropertiesGroupingStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).getSeparator();
        }

        private void refillActionGroup() {
            this.removeAll();
            for (final String separator : this.myPredefinedSeparators) {
                if (separator.equals(this.getCurrentSeparator())) continue;
                AnAction action = new AnAction(){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ((PropertiesGroupingStructureViewModel)PropertiesGroupingStructureViewComponent.this.getTreeModel()).setSeparator(separator);
                        PropertiesGroupingStructureViewComponent.this.setActionActive("GROUP_BY_PREFIXES", true);
                        ChangeGroupSeparatorAction.this.refillActionGroup();
                        PropertiesGroupingStructureViewComponent.this.rebuild();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent$ChangeGroupSeparatorAction$1", "actionPerformed"));
                    }
                };
                action.getTemplatePresentation().setText(separator, false);
                this.add(action);
            }
            this.add(new SelectSeparatorAction());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent$ChangeGroupSeparatorAction", "update"));
        }

        private final class SelectSeparatorAction
        extends AnAction {
            SelectSeparatorAction() {
                super(PropertiesBundle.messagePointer("select.separator.action.with.empty.separator.name", new Object[0]));
            }

            public final void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    SelectSeparatorAction.$$$reportNull$$$0(0);
                }
                String[] strings = ArrayUtilRt.toStringArray(ChangeGroupSeparatorAction.this.myPredefinedSeparators);
                String current = ChangeGroupSeparatorAction.this.getCurrentSeparator();
                String separator = Messages.showEditableChooseDialog((String)PropertiesBundle.message("select.property.separator.dialog.text", new Object[0]), (String)PropertiesBundle.message("select.property.separator.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String[])strings, (String)current, null);
                if (separator == null) {
                    return;
                }
                ChangeGroupSeparatorAction.this.myPredefinedSeparators.add(separator);
                ChangeGroupSeparatorAction.this.refillActionGroup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/PropertiesGroupingStructureViewComponent$ChangeGroupSeparatorAction$SelectSeparatorAction", "actionPerformed"));
            }
        }
    }
}

