/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.DarkIconProvider;
import com.intellij.ui.icons.MenuBarIconProvider;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextSupport;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.SVGLoader;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.lang.ref.Reference;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class LazyImageIcon
extends ScaleContextSupport
implements CopyableIcon,
ScalableIcon,
DarkIconProvider,
MenuBarIconProvider {
    protected final Object myLock = new Object();
    @Nullable
    protected volatile Object myRealIcon;

    protected LazyImageIcon() {
        ((ScaleContext)this.getScaleContext()).addUpdateListener(new UserScaleContext.UpdateListener(){

            @Override
            public void contextUpdated() {
                LazyImageIcon.this.myRealIcon = null;
            }
        });
    }

    @Nullable
    protected static ImageIcon unwrapIcon(Object realIcon) {
        Object icon = realIcon;
        if (icon instanceof Reference) {
            icon = ((Reference)icon).get();
        }
        return icon instanceof ImageIcon ? (ImageIcon)icon : null;
    }

    @Override
    public final void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
        ScaleContext ctx = ScaleContext.create(g2d);
        if (SVGLoader.isSelectionContext()) {
            this.getRealIconForSelection(ctx).paintIcon(c, g, x, y);
        } else {
            this.getRealIcon(ctx).paintIcon(c, g, x, y);
        }
    }

    @Override
    public int getIconWidth() {
        return this.getRealIcon().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getRealIcon().getIconHeight();
    }

    public float getScale() {
        return 1.0f;
    }

    @ApiStatus.Internal
    @NotNull
    public final ImageIcon getRealIcon() {
        ImageIcon imageIcon = this.getRealIcon(null);
        if (imageIcon == null) {
            LazyImageIcon.$$$reportNull$$$0(0);
        }
        return imageIcon;
    }

    @NotNull
    protected abstract ImageIcon getRealIcon(@Nullable ScaleContext var1);

    protected ImageIcon getRealIconForSelection(@Nullable ScaleContext context) {
        return this.getRealIcon(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/icons/LazyImageIcon", "getRealIcon"));
    }
}

