/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.devkit.model.impl;

import com.intellij.openapi.util.JDOMExternalizerUtil;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.devkit.model.JpsIdeaSdkProperties;
import org.jetbrains.jps.devkit.model.JpsIdeaSdkType;
import org.jetbrains.jps.devkit.model.JpsPluginModuleProperties;
import org.jetbrains.jps.devkit.model.JpsPluginModuleType;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.library.JpsSdkPropertiesSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModulePropertiesSerializer;

public class JpsDevKitModelSerializerExtension
extends JpsModelSerializerExtension {
    @NotNull
    public List<? extends JpsModulePropertiesSerializer<?>> getModulePropertiesSerializers() {
        List<JpsPluginModulePropertiesSerializer> list = Collections.singletonList(new JpsPluginModulePropertiesSerializer());
        if (list == null) {
            JpsDevKitModelSerializerExtension.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<? extends JpsSdkPropertiesSerializer<?>> getSdkPropertiesSerializers() {
        List<JpsIdeaSdkPropertiesSerializer> list = Collections.singletonList(new JpsIdeaSdkPropertiesSerializer());
        if (list == null) {
            JpsDevKitModelSerializerExtension.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulePropertiesSerializers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkPropertiesSerializers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class JpsPluginModulePropertiesSerializer
    extends JpsModulePropertiesSerializer<JpsSimpleElement<JpsPluginModuleProperties>> {
        private static final String URL_ATTRIBUTE = "url";
        private static final String MANIFEST_ATTRIBUTE = "manifest";

        private JpsPluginModulePropertiesSerializer() {
            super((JpsModuleType)JpsPluginModuleType.INSTANCE, "PLUGIN_MODULE", "DevKit.ModuleBuildProperties");
        }

        public JpsSimpleElement<JpsPluginModuleProperties> loadProperties(@Nullable Element componentElement) {
            String pluginXmlUrl = componentElement != null ? componentElement.getAttributeValue(URL_ATTRIBUTE) : null;
            String manifestFileUrl = componentElement != null ? componentElement.getAttributeValue(MANIFEST_ATTRIBUTE) : null;
            return JpsElementFactory.getInstance().createSimpleElement((Object)new JpsPluginModuleProperties(pluginXmlUrl, manifestFileUrl));
        }
    }

    private static class JpsIdeaSdkPropertiesSerializer
    extends JpsSdkPropertiesSerializer<JpsSimpleElement<JpsIdeaSdkProperties>> {
        private static final String SANDBOX_HOME_FIELD = "mySandboxHome";
        private static final String JDK_NAME_ATTRIBUTE = "sdk";

        JpsIdeaSdkPropertiesSerializer() {
            super("IDEA JDK", (JpsSdkType)JpsIdeaSdkType.INSTANCE);
        }

        @NotNull
        public JpsSimpleElement<JpsIdeaSdkProperties> loadProperties(@Nullable Element propertiesElement) {
            String sandboxHome = null;
            String jdkName = null;
            if (propertiesElement != null) {
                sandboxHome = JDOMExternalizerUtil.readField((Element)propertiesElement, (String)SANDBOX_HOME_FIELD);
                jdkName = propertiesElement.getAttributeValue(JDK_NAME_ATTRIBUTE);
            }
            JpsSimpleElement jpsSimpleElement = JpsElementFactory.getInstance().createSimpleElement((Object)new JpsIdeaSdkProperties(sandboxHome, jdkName));
            if (jpsSimpleElement == null) {
                JpsIdeaSdkPropertiesSerializer.$$$reportNull$$$0(0);
            }
            return jpsSimpleElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/devkit/model/impl/JpsDevKitModelSerializerExtension$JpsIdeaSdkPropertiesSerializer", "loadProperties"));
        }
    }
}

