/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.konan.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrLineBreakpointType;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpointType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\"\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016J\u001e\u0010\u0018\u001a\u00020\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016RB\u0010\t\u001a6\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00020\nj\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/konan/debugger/KonanBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties;", "cidrHandler", "Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrBreakpointHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrBreakpointHandler;Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/HashMap;", "Lcom/jetbrains/konan/debugger/KonanBreakpointHandler$BreakpointLocation;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "", "Lkotlin/collections/HashMap;", "getProject", "()Lcom/intellij/openapi/project/Project;", "timeStamp", "", "convert", "breakpoint", "convertWithCache", "registerBreakpoint", "", "unregisterBreakpoint", "temporary", "", "BreakpointLocation", "kotlin-ultimate.common-native"})
public final class KonanBreakpointHandler
extends XBreakpointHandler<XLineBreakpoint<JavaLineBreakpointProperties>> {
    private long timeStamp;
    private final HashMap<BreakpointLocation, XLineBreakpoint<XBreakpointProperties<Object>>> cache;
    private final CidrBreakpointHandler cidrHandler;
    @NotNull
    private final Project project;

    private final XLineBreakpoint<XBreakpointProperties<Object>> convert(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(project)");
        XBreakpointManager xBreakpointManager = xDebuggerManager.getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"XDebuggerManager.getInst\u2026roject).breakpointManager");
        XBreakpointManager breakpointManager = xBreakpointManager;
        CidrLineBreakpointType breakpointType = new CidrLineBreakpointType();
        KonanBreakpointHandler konanBreakpointHandler = this;
        ++konanBreakpointHandler.timeStamp;
        LineBreakpointState state = new LineBreakpointState(true, breakpointType.getId(), breakpoint.getFileUrl(), breakpoint.getLine(), true, konanBreakpointHandler.timeStamp, breakpointType.getDefaultSuspendPolicy());
        XBreakpointManager xBreakpointManager2 = breakpointManager;
        if (xBreakpointManager2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl");
        }
        return (XLineBreakpoint)new XLineBreakpointImpl((XLineBreakpointType)breakpointType, (XBreakpointManagerImpl)xBreakpointManager2, null, state);
    }

    private final XLineBreakpoint<XBreakpointProperties<Object>> convertWithCache(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        String string = breakpoint.getFileUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"breakpoint.fileUrl");
        BreakpointLocation breakpointLocation = new BreakpointLocation(string, breakpoint.getLine());
        if (!this.cache.containsKey(breakpointLocation)) {
            ((Map)this.cache).put(breakpointLocation, this.convert(breakpoint));
        }
        XLineBreakpoint<XBreakpointProperties<Object>> xLineBreakpoint = this.cache.get(breakpointLocation);
        Intrinsics.checkNotNull(xLineBreakpoint);
        return xLineBreakpoint;
    }

    public void registerBreakpoint(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        this.cidrHandler.registerBreakpoint((XBreakpoint)this.convertWithCache(breakpoint));
    }

    public void unregisterBreakpoint(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint, boolean temporary) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        this.cidrHandler.unregisterBreakpoint((XBreakpoint)this.convertWithCache(breakpoint), temporary);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KonanBreakpointHandler(@NotNull CidrBreakpointHandler cidrHandler, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)cidrHandler, (String)"cidrHandler");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(KotlinLineBreakpointType.class);
        this.cidrHandler = cidrHandler;
        this.project = project;
        this.timeStamp = 0xFFFFFFFFL;
        this.cache = new HashMap();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/konan/debugger/KonanBreakpointHandler$BreakpointLocation;", "", "fileUrl", "", "line", "", "(Ljava/lang/String;I)V", "getFileUrl", "()Ljava/lang/String;", "getLine", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "kotlin-ultimate.common-native"})
    public static final class BreakpointLocation {
        @NotNull
        private final String fileUrl;
        private final int line;

        @NotNull
        public final String getFileUrl() {
            return this.fileUrl;
        }

        public final int getLine() {
            return this.line;
        }

        public BreakpointLocation(@NotNull String fileUrl, int line) {
            Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
            this.fileUrl = fileUrl;
            this.line = line;
        }

        @NotNull
        public final String component1() {
            return this.fileUrl;
        }

        public final int component2() {
            return this.line;
        }

        @NotNull
        public final BreakpointLocation copy(@NotNull String fileUrl, int line) {
            Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
            return new BreakpointLocation(fileUrl, line);
        }

        public static /* synthetic */ BreakpointLocation copy$default(BreakpointLocation breakpointLocation, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = breakpointLocation.fileUrl;
            }
            if ((n2 & 2) != 0) {
                n = breakpointLocation.line;
            }
            return breakpointLocation.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "BreakpointLocation(fileUrl=" + this.fileUrl + ", line=" + this.line + ")";
        }

        public int hashCode() {
            String string = this.fileUrl;
            return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.line);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BreakpointLocation)) break block3;
                    BreakpointLocation breakpointLocation = (BreakpointLocation)object;
                    if (!Intrinsics.areEqual((Object)this.fileUrl, (Object)breakpointLocation.fileUrl) || this.line != breakpointLocation.line) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

