/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSshProcess;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jediterm.terminal.ProcessTtyConnector;
import com.pty4j.unix.UnixPtyProcess;
import com.pty4j.windows.WinPtyProcess;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalTabState;

public final class TerminalUtil {
    private static final Logger LOG = Logger.getInstance(TerminalUtil.class);

    private TerminalUtil() {
    }

    @NotNull
    public static JBTerminalWidget createTerminal(@NotNull AbstractTerminalRunner terminalRunner, @Nullable TerminalTabState tabState, @Nullable Disposable parentDisposable) {
        if (terminalRunner == null) {
            TerminalUtil.$$$reportNull$$$0(0);
        }
        VirtualFile currentWorkingDir = TerminalUtil.getCurrentWorkingDir(tabState);
        if (parentDisposable == null) {
            parentDisposable = Disposer.newDisposable();
        }
        JBTerminalWidget jBTerminalWidget = terminalRunner.createTerminalWidget(parentDisposable, currentWorkingDir);
        if (jBTerminalWidget == null) {
            TerminalUtil.$$$reportNull$$$0(1);
        }
        return jBTerminalWidget;
    }

    @Nullable
    private static VirtualFile getCurrentWorkingDir(@Nullable TerminalTabState tabState) {
        String dir = tabState != null ? tabState.myWorkingDirectory : null;
        VirtualFile result = null;
        if (dir != null) {
            result = LocalFileSystem.getInstance().findFileByPath(dir);
        }
        return result;
    }

    public static boolean hasRunningCommands(@NotNull ProcessTtyConnector connector) throws IllegalStateException {
        Process process;
        if (connector == null) {
            TerminalUtil.$$$reportNull$$$0(2);
        }
        if (!(process = connector.getProcess()).isAlive()) {
            return false;
        }
        if (process instanceof RemoteSshProcess) {
            return true;
        }
        if (SystemInfo.isUnix && process instanceof UnixPtyProcess) {
            int shellPid = OSProcessUtil.getProcessID((Process)process);
            MultiMap pidToChildPidsMap = MultiMap.create();
            UnixProcessManager.processPSOutput((String[])UnixProcessManager.getPSCmd((boolean)false, (boolean)false), s -> {
                StringTokenizer st = new StringTokenizer((String)s, " ");
                int parentPid = Integer.parseInt(st.nextToken());
                int pid = Integer.parseInt(st.nextToken());
                pidToChildPidsMap.putValue((Object)parentPid, (Object)pid);
                return false;
            });
            return !pidToChildPidsMap.get((Object)shellPid).isEmpty();
        }
        if (SystemInfo.isWindows && process instanceof WinPtyProcess) {
            WinPtyProcess winPty = (WinPtyProcess)process;
            try {
                String executable = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)TerminalUtil.getExecutable(winPty)));
                int consoleProcessCount = winPty.getConsoleProcessCount();
                if (executable.endsWith("/Git/bin/bash.exe")) {
                    return consoleProcessCount > 3;
                }
                return consoleProcessCount > 2;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        LOG.warn("Cannot determine if there are running processes: " + SystemInfo.OS_NAME + ", " + process.getClass().getName());
        return false;
    }

    @Nullable
    private static String getExecutable(@NotNull WinPtyProcess process) {
        if (process == null) {
            TerminalUtil.$$$reportNull$$$0(3);
        }
        return (String)ContainerUtil.getFirstItem((List)process.getCommand());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTerminal";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasRunningCommands";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getExecutable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

