/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.artifactResolver.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;

public final class MavenModuleMap {
    private static final MavenModuleMap ourInstance = new MavenModuleMap();
    public static final String PATHS_FILE_PROPERTY = "idea.modules.paths.file";
    private final Properties myMap = new Properties();

    private MavenModuleMap() {
        String path = System.getProperty(PATHS_FILE_PROPERTY);
        if (path != null) {
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
                try {
                    this.myMap.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static MavenModuleMap getInstance() {
        return ourInstance;
    }

    public boolean resolveToModule(Artifact artifact) {
        String extension = artifact.getArtifactHandler().getExtension();
        File file = this.findArtifact(artifact.getGroupId(), artifact.getArtifactId(), extension, artifact.getType(), artifact.getBaseVersion());
        if (file == null) {
            return false;
        }
        artifact.setFile(file);
        artifact.setResolved(true);
        return true;
    }

    public File findArtifact(String groupId, String artifactId, String extension, String classifier, String baseVersion) {
        String key;
        String value;
        String type = extension;
        if ("jar".equals(type) && classifier != null && !classifier.isEmpty()) {
            String string = type = "tests".equals(classifier) || "test-jar".equals(classifier) ? "test-jar" : classifier;
        }
        if ((value = this.myMap.getProperty(key = groupId + ':' + artifactId + ':' + type + ':' + baseVersion)) == null || value.length() == 0) {
            return null;
        }
        File file = new File(value);
        if (!file.exists()) {
            return null;
        }
        return file;
    }
}

