/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.provider;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.provider.LombokProcessorData;
import de.plushnikov.intellij.plugin.provider.LombokProcessorProvider;
import java.util.Collection;

public class LombokImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        return this.isImplicitWrite(element) || this.isImplicitRead(element);
    }

    public boolean isImplicitRead(PsiElement element) {
        return this.checkUsage(element, LombokPsiElementUsage.READ);
    }

    public boolean isImplicitWrite(PsiElement element) {
        return this.checkUsage(element, LombokPsiElementUsage.WRITE);
    }

    private boolean checkUsage(PsiElement element, LombokPsiElementUsage elementUsage) {
        boolean result = false;
        if (element instanceof PsiField) {
            LombokProcessorProvider processorProvider = LombokProcessorProvider.getInstance(element.getProject());
            Collection<LombokProcessorData> applicableProcessors = processorProvider.getApplicableProcessors((PsiMember)((PsiField)element));
            for (LombokProcessorData processorData : applicableProcessors) {
                LombokPsiElementUsage psiElementUsage = processorData.getProcessor().checkFieldUsage((PsiField)element, processorData.getPsiAnnotation());
                if (elementUsage != psiElementUsage && LombokPsiElementUsage.READ_WRITE != psiElementUsage) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

