/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.provider;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import de.plushnikov.intellij.plugin.activity.LombokProjectValidatorActivity;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.Processor;
import de.plushnikov.intellij.plugin.processor.ValProcessor;
import de.plushnikov.intellij.plugin.processor.modifier.ModifierProcessor;
import de.plushnikov.intellij.plugin.provider.LombokProcessorProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokAugmentProvider
extends PsiAugmentProvider {
    private static final Logger log = Logger.getInstance((String)LombokAugmentProvider.class.getName());
    private final ValProcessor valProcessor;
    private final Collection<ModifierProcessor> modifierProcessors;

    public LombokAugmentProvider() {
        log.debug("LombokAugmentProvider created");
        this.modifierProcessors = LombokProcessorManager.getLombokModifierProcessors();
        this.valProcessor = (ValProcessor)ApplicationManager.getApplication().getService(ValProcessor.class);
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList, @NotNull Set<String> modifiers) {
        if (modifierList == null) {
            LombokAugmentProvider.$$$reportNull$$$0(0);
        }
        if (modifiers == null) {
            LombokAugmentProvider.$$$reportNull$$$0(1);
        }
        HashSet<String> result = new HashSet<String>(modifiers);
        for (ModifierProcessor processor : this.modifierProcessors) {
            if (!processor.isSupported(modifierList)) continue;
            processor.transformModifiers(modifierList, result);
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            LombokAugmentProvider.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public boolean canInferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            LombokAugmentProvider.$$$reportNull$$$0(3);
        }
        return this.valProcessor.canInferType(typeElement);
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            LombokAugmentProvider.$$$reportNull$$$0(4);
        }
        return this.valProcessor.inferType(typeElement);
    }

    @NotNull
    public <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            LombokAugmentProvider.$$$reportNull$$$0(5);
        }
        if (type == null) {
            LombokAugmentProvider.$$$reportNull$$$0(6);
        }
        List emptyResult = Collections.emptyList();
        if (type != PsiClass.class && type != PsiField.class && type != PsiMethod.class || !(element instanceof PsiExtensibleClass)) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        PsiClass psiClass = (PsiClass)element;
        if (psiClass.isAnnotationType() || psiClass.isInterface()) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        Project project = element.getProject();
        if (!LombokProjectValidatorActivity.hasLombokLibrary(project)) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        List cachedValue = type == PsiField.class ? (List)CachedValuesManager.getCachedValue((PsiElement)element, new FieldLombokCachedValueProvider<Psi>(type, psiClass)) : (type == PsiMethod.class ? (List)CachedValuesManager.getCachedValue((PsiElement)element, new MethodLombokCachedValueProvider<Psi>(type, psiClass)) : (List)CachedValuesManager.getCachedValue((PsiElement)element, new ClassLombokCachedValueProvider<Psi>(type, psiClass)));
        List list = null != cachedValue ? cachedValue : emptyResult;
        if (list == null) {
            LombokAugmentProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getPsis(PsiClass psiClass, Class<Psi> type) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        Collection<Processor> lombokProcessors = LombokProcessorProvider.getInstance(psiClass.getProject()).getLombokProcessors(type);
        for (Processor processor : lombokProcessors) {
            List<? super PsiElement> generatedElements = processor.process(psiClass);
            for (PsiElement psiElement : generatedElements) {
                result.add(psiElement);
            }
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            LombokAugmentProvider.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/provider/LombokAugmentProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/provider/LombokAugmentProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "transformModifiers";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transformModifiers";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canInferType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class LombokCachedValueProvider<Psi extends PsiElement>
    implements CachedValueProvider<List<Psi>> {
        private final Class<Psi> type;
        private final PsiClass psiClass;
        private final RecursionGuard<PsiClass> recursionGuard;

        LombokCachedValueProvider(Class<Psi> type, PsiClass psiClass, RecursionGuard<PsiClass> recursionGuard) {
            this.type = type;
            this.psiClass = psiClass;
            this.recursionGuard = recursionGuard;
        }

        @Nullable
        public CachedValueProvider.Result<List<Psi>> compute() {
            return (CachedValueProvider.Result)this.recursionGuard.doPreventingRecursion((Object)this.psiClass, true, this::computeIntern);
        }

        private CachedValueProvider.Result<List<Psi>> computeIntern() {
            List<Psi> result = LombokAugmentProvider.getPsis(this.psiClass, this.type);
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{this.psiClass});
        }
    }

    private static class ClassLombokCachedValueProvider<Psi extends PsiElement>
    extends LombokCachedValueProvider<Psi> {
        private static final RecursionGuard<PsiClass> ourGuard = RecursionManager.createGuard((String)"lombok.augment.class");

        ClassLombokCachedValueProvider(Class<Psi> type, PsiClass psiClass) {
            super(type, psiClass, ourGuard);
        }
    }

    private static class MethodLombokCachedValueProvider<Psi extends PsiElement>
    extends LombokCachedValueProvider<Psi> {
        private static final RecursionGuard<PsiClass> ourGuard = RecursionManager.createGuard((String)"lombok.augment.method");

        MethodLombokCachedValueProvider(Class<Psi> type, PsiClass psiClass) {
            super(type, psiClass, ourGuard);
        }
    }

    private static class FieldLombokCachedValueProvider<Psi extends PsiElement>
    extends LombokCachedValueProvider<Psi> {
        private static final RecursionGuard<PsiClass> ourGuard = RecursionManager.createGuard((String)"lombok.augment.field");

        FieldLombokCachedValueProvider(Class<Psi> type, PsiClass psiClass) {
            super(type, psiClass, ourGuard);
        }
    }
}

