/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemEmptyBuilder;
import de.plushnikov.intellij.plugin.problem.ProblemNewBuilder;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.ClassProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClassProcessor
extends AbstractProcessor
implements ClassProcessor {
    protected AbstractClassProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass) {
        if (supportedClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    protected AbstractClassProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass, @NotNull String equivalentAnnotationClass) {
        if (supportedClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(2);
        }
        if (supportedAnnotationClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(3);
        }
        if (equivalentAnnotationClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(4);
        }
        super(supportedClass, supportedAnnotationClass, equivalentAnnotationClass);
    }

    @Override
    @NotNull
    public List<? super PsiElement> process(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(5);
        }
        List result = Collections.emptyList();
        PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, this.getSupportedAnnotationClasses());
        if (null != psiAnnotation && this.supportAnnotationVariant(psiAnnotation) && this.validate(psiAnnotation, psiClass, ProblemEmptyBuilder.getInstance())) {
            result = new ArrayList();
            this.generatePsiElements(psiClass, psiAnnotation, result);
        }
        List list = result;
        if (list == null) {
            AbstractClassProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(7);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, this.getSupportedAnnotationClasses());
        if (null != psiAnnotation) {
            result.add(psiAnnotation);
        }
        ArrayList<PsiAnnotation> arrayList = result;
        if (arrayList == null) {
            AbstractClassProcessor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    protected void addClassAnnotation(Collection<PsiAnnotation> result, @NotNull PsiClass psiClass, String ... annotationFQNs) {
        PsiAnnotation psiAnnotation;
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(9);
        }
        if (null != (psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, annotationFQNs))) {
            result.add(psiAnnotation);
        }
    }

    protected void addFieldsAnnotation(Collection<PsiAnnotation> result, @NotNull PsiClass psiClass, String ... annotationFQNs) {
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(10);
        }
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, annotationFQNs);
            if (null == psiAnnotation) continue;
            result.add(psiAnnotation);
        }
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractClassProcessor.$$$reportNull$$$0(11);
        }
        Collection<LombokProblem> result = Collections.emptyList();
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, (Class[])new Class[]{PsiField.class, PsiMethod.class, PsiClass.class});
        if (psiElement instanceof PsiClass) {
            ProblemNewBuilder problemNewBuilder = new ProblemNewBuilder();
            this.validate(psiAnnotation, (PsiClass)psiElement, problemNewBuilder);
            result = problemNewBuilder.getProblems();
        }
        List<LombokProblem> list = result;
        if (list == null) {
            AbstractClassProcessor.$$$reportNull$$$0(12);
        }
        return list;
    }

    protected Optional<PsiClass> getSupportedParentClass(@NotNull PsiClass psiClass) {
        PsiElement parentElement;
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(13);
        }
        if ((parentElement = psiClass.getParent()) instanceof PsiClass && !(parentElement instanceof LombokLightClassBuilder)) {
            return Optional.of((PsiClass)parentElement);
        }
        return Optional.empty();
    }

    @Nullable
    protected PsiAnnotation getSupportedAnnotation(@NotNull PsiClass psiParentClass) {
        if (psiParentClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(14);
        }
        return PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiParentClass, this.getSupportedAnnotationClasses());
    }

    protected abstract boolean validate(@NotNull PsiAnnotation var1, @NotNull PsiClass var2, @NotNull ProblemBuilder var3);

    protected abstract void generatePsiElements(@NotNull PsiClass var1, @NotNull PsiAnnotation var2, @NotNull List<? super PsiElement> var3);

    void validateOfParam(PsiClass psiClass, ProblemBuilder builder, PsiAnnotation psiAnnotation, Collection<String> ofProperty) {
        for (String fieldName : ofProperty) {
            PsiField fieldByName;
            if (StringUtil.isEmptyOrSpaces((String)fieldName) || null != (fieldByName = psiClass.findFieldByName(fieldName, false))) continue;
            String newPropertyValue = this.calcNewPropertyValue(ofProperty, fieldName);
            builder.addWarning(String.format("The field '%s' does not exist", fieldName), PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "of", newPropertyValue));
        }
    }

    void validateExcludeParam(PsiClass psiClass, ProblemBuilder builder, PsiAnnotation psiAnnotation, Collection<String> excludeProperty) {
        for (String fieldName : excludeProperty) {
            String newPropertyValue;
            if (StringUtil.isEmptyOrSpaces((String)fieldName)) continue;
            PsiField fieldByName = psiClass.findFieldByName(fieldName, false);
            if (null == fieldByName) {
                newPropertyValue = this.calcNewPropertyValue(excludeProperty, fieldName);
                builder.addWarning(String.format("The field '%s' does not exist", fieldName), PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "exclude", newPropertyValue));
                continue;
            }
            if (!fieldName.startsWith("$") && !fieldByName.hasModifierProperty("static")) continue;
            newPropertyValue = this.calcNewPropertyValue(excludeProperty, fieldName);
            builder.addWarning(String.format("The field '%s' would have been excluded anyway", fieldName), PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "exclude", newPropertyValue));
        }
    }

    private String calcNewPropertyValue(Collection<String> allProperties, String fieldName) {
        String result;
        block2: {
            block3: {
                result = null;
                if (allProperties.isEmpty()) break block2;
                if (allProperties.size() > 1) break block3;
                if (allProperties.contains(fieldName)) break block2;
            }
            result = allProperties.stream().filter(((Predicate<String>)fieldName::equals).negate()).collect(Collectors.joining("\",\"", "{\"", "\"}"));
        }
        return result;
    }

    boolean shouldGenerateExtraNoArgsConstructor(@NotNull PsiClass psiClass) {
        boolean result;
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(15);
        }
        boolean bl = result = !PsiClassUtil.hasSuperClass(psiClass);
        if (result) {
            result = this.configDiscovery.getBooleanLombokConfigProperty(ConfigKey.NO_ARGS_CONSTRUCTOR_EXTRA_PRIVATE, psiClass);
        }
        if (result) {
            result = PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.NoArgsConstructor", "lombok.AllArgsConstructor", "lombok.RequiredArgsConstructor");
        }
        return result;
    }

    boolean readCallSuperAnnotationOrConfigProperty(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ConfigKey configKey) {
        boolean result;
        Boolean declaredAnnotationValue;
        if (psiAnnotation == null) {
            AbstractClassProcessor.$$$reportNull$$$0(16);
        }
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(17);
        }
        if (configKey == null) {
            AbstractClassProcessor.$$$reportNull$$$0(18);
        }
        if (null == (declaredAnnotationValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(psiAnnotation, "callSuper"))) {
            String configProperty = this.configDiscovery.getStringLombokConfigProperty(configKey, psiClass);
            result = PsiClassUtil.hasSuperClass(psiClass) && "CALL".equalsIgnoreCase(configProperty);
        } else {
            result = declaredAnnotationValue;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equivalentAnnotationClass";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/AbstractClassProcessor";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParentClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/AbstractClassProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addClassAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFieldsAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedParentClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedAnnotation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateExtraNoArgsConstructor";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readCallSuperAnnotationOrConfigProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

