/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.action.lombok;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.EncapsulatableClassMember;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PropertyUtilBase;
import de.plushnikov.intellij.plugin.action.BaseRefactorHandler;
import java.util.ArrayList;
import java.util.List;

public class RefactorSetterHandler
extends BaseRefactorHandler {
    public RefactorSetterHandler(Project project, DataContext dataContext) {
        super(dataContext, project);
    }

    @Override
    protected String getChooserTitle() {
        return "Select Fields to replace Setter-Method With @Getter";
    }

    @Override
    protected String getNothingFoundMessage() {
        return "No field getter have been found to generate @Setter for";
    }

    @Override
    protected String getNothingAcceptedMessage() {
        return "No fields with setter method were found";
    }

    @Override
    protected List<EncapsulatableClassMember> getEncapsulatableClassMembers(PsiClass psiClass) {
        ArrayList<EncapsulatableClassMember> result = new ArrayList<EncapsulatableClassMember>();
        for (PsiField field : psiClass.getFields()) {
            if (null == PropertyUtilBase.findPropertySetter((PsiClass)psiClass, (String)field.getName(), (boolean)false, (boolean)false)) continue;
            result.add((EncapsulatableClassMember)new PsiFieldMember(field));
        }
        return result;
    }

    @Override
    protected void process(List<ClassMember> classMembers) {
        for (ClassMember classMember : classMembers) {
            PsiModifierList modifierList;
            PsiElementClassMember elementClassMember = (PsiElementClassMember)classMember;
            PsiField psiField = (PsiField)elementClassMember.getPsiElement();
            PsiMethod psiMethod = PropertyUtilBase.findPropertySetter((PsiClass)psiField.getContainingClass(), (String)psiField.getName(), (boolean)false, (boolean)false);
            if (null == psiMethod || null == (modifierList = psiField.getModifierList())) continue;
            modifierList.addAnnotation("lombok.Setter");
            psiMethod.delete();
        }
    }
}

