/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MatchResultImpl
extends MatchResult {
    private String name;
    private SmartPsiPointer matchRef;
    private int start;
    private int end;
    private String matchImage;
    private final List<MatchResult> myChildren;
    private boolean target;
    private boolean myScopeMatch;
    private boolean myMultipleMatch;
    private MatchResultImpl parent;

    MatchResultImpl() {
        this.end = -1;
        this.myChildren = new SmartList();
    }

    public MatchResultImpl(@NotNull String name, @Nullable String image, @NotNull SmartPsiPointer ref, boolean target) {
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(0);
        }
        if (ref == null) {
            MatchResultImpl.$$$reportNull$$$0(1);
        }
        this(name, image, ref, 0, -1, target);
    }

    public MatchResultImpl(@NotNull String name, @Nullable String image, @NotNull SmartPsiPointer ref, int start, int end, boolean target) {
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(2);
        }
        if (ref == null) {
            MatchResultImpl.$$$reportNull$$$0(3);
        }
        this.end = -1;
        this.myChildren = new SmartList();
        this.matchRef = ref;
        this.name = name;
        this.matchImage = image;
        this.target = target;
        this.start = start;
        this.end = end;
    }

    @Override
    public String getMatchImage() {
        return this.matchImage;
    }

    @Override
    public SmartPsiPointer getMatchRef() {
        return this.matchRef;
    }

    @Override
    public PsiElement getMatch() {
        if (this.matchRef == null) {
            return null;
        }
        return this.matchRef.getElement();
    }

    public void setMatchRef(@NotNull SmartPsiPointer matchStart) {
        if (matchStart == null) {
            MatchResultImpl.$$$reportNull$$$0(4);
        }
        this.matchRef = matchStart;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(5);
        }
        this.name = name;
    }

    @Override
    @NotNull
    public List<MatchResult> getChildren() {
        List<MatchResult> list = Collections.unmodifiableList(this.myChildren);
        if (list == null) {
            MatchResultImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public int size() {
        if (!this.myMultipleMatch) {
            return this.getMatch() != null ? 1 : 0;
        }
        return this.myChildren.size();
    }

    @Override
    public boolean isScopeMatch() {
        return this.myScopeMatch;
    }

    @Override
    public boolean isMultipleMatch() {
        return this.myMultipleMatch;
    }

    @Override
    public boolean hasChildren() {
        return !this.myChildren.isEmpty();
    }

    public void removeChildren() {
        this.myChildren.clear();
    }

    @NotNull
    public MatchResult removeLastChild() {
        MatchResult matchResult = this.myChildren.remove(this.myChildren.size() - 1);
        if (matchResult == null) {
            MatchResultImpl.$$$reportNull$$$0(7);
        }
        return matchResult;
    }

    public void setScopeMatch(boolean scopeMatch) {
        this.myScopeMatch = scopeMatch;
    }

    public void setMultipleMatch(boolean multipleMatch) {
        this.myMultipleMatch = multipleMatch;
    }

    public MatchResultImpl findChild(@NotNull String name) {
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(8);
        }
        for (MatchResult match : this.myChildren) {
            MatchResultImpl res = (MatchResultImpl)match;
            if (!name.equals(res.getName())) continue;
            return res;
        }
        return null;
    }

    public static MatchResultImpl findChildDeep(@NotNull MatchResult match, @NotNull String name) {
        if (match == null) {
            MatchResultImpl.$$$reportNull$$$0(9);
        }
        if (name == null) {
            MatchResultImpl.$$$reportNull$$$0(10);
        }
        for (MatchResult child : match.getChildren()) {
            if (name.equals(child.getName())) {
                return (MatchResultImpl)child;
            }
            MatchResultImpl deep = MatchResultImpl.findChildDeep(child, name);
            if (deep == null) continue;
            return deep;
        }
        return null;
    }

    public MatchResult removeChild(@NotNull String typedVar) {
        if (typedVar == null) {
            MatchResultImpl.$$$reportNull$$$0(11);
        }
        int size = this.myChildren.size();
        for (int i = 0; i < size; ++i) {
            MatchResult child = this.myChildren.get(i);
            if (!typedVar.equals(child.getName())) continue;
            this.myChildren.remove(i);
            return child;
        }
        return null;
    }

    public void addChild(@NotNull MatchResult result) {
        if (result == null) {
            MatchResultImpl.$$$reportNull$$$0(12);
        }
        if (result instanceof MatchResultImpl) {
            ((MatchResultImpl)result).parent = this;
        }
        this.myChildren.add(result);
    }

    @Override
    @NotNull
    public MatchResult getRoot() {
        if (this.parent == null) {
            MatchResultImpl matchResultImpl = this;
            if (matchResultImpl == null) {
                MatchResultImpl.$$$reportNull$$$0(13);
            }
            return matchResultImpl;
        }
        MatchResultImpl root = this.parent;
        while (root.parent != null) {
            root = root.parent;
        }
        MatchResultImpl matchResultImpl = root;
        if (matchResultImpl == null) {
            MatchResultImpl.$$$reportNull$$$0(14);
        }
        return matchResultImpl;
    }

    public void setMatchImage(@NotNull String matchImage) {
        if (matchImage == null) {
            MatchResultImpl.$$$reportNull$$$0(15);
        }
        this.matchImage = matchImage;
    }

    @Override
    public boolean isTarget() {
        return this.target;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public String toString() {
        return "MatchResultImpl{name='" + this.name + "', matchImage='" + this.matchImage + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStart";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/MatchResultImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedVar";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchImage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/MatchResultImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastChild";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setMatchRef";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findChildDeep";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setMatchImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

