/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

class TestTags
extends TestObject {
    TestTags(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
        String tags = this.getConfiguration().getPersistentData().getTags();
        if (StringUtil.isEmptyOrSpaces((String)tags)) {
            throw new RuntimeConfigurationError(JUnitBundle.message("tags.are.not.specified.error.message", new Object[0]));
        }
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule();
        if (this.getSourceScope() == null) {
            configurationModule.checkForWarning();
        }
        this.parseAsJavaExpression(tags);
    }

    @Override
    @Nullable
    public SourceScope getSourceScope() {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        return data.getScope().getSourceScope((ModuleBasedConfiguration)this.getConfiguration());
    }

    private void parseAsJavaExpression(String tags) throws RuntimeConfigurationWarning {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getConfiguration().getProject());
        try {
            IElementType tokenType;
            PsiExpression expression = elementFactory.createExpressionFromText(tags.replaceAll("[^)(&|!\\s]", "x"), null);
            if (expression instanceof PsiPolyadicExpression && ((tokenType = ((PsiPolyadicExpression)expression).getOperationTokenType()) == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR)) {
                TestTags.invalidTagException(tags);
            }
        }
        catch (IncorrectOperationException e) {
            TestTags.invalidTagException(tags);
        }
    }

    private static void invalidTagException(String tag) throws RuntimeConfigurationWarning {
        throw new RuntimeConfigurationWarning(JUnitBundle.message("tag.name.0.must.be.syntactically.valid.warning", tag));
    }

    @Override
    public String suggestActionName() {
        return JUnitBundle.message("action.text.test.tags", this.getConfiguration().getPersistentData().getTags());
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return false;
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        this.addClassesListToJavaParameters(Collections.emptyList(), s -> "", "", true, javaParameters);
        return javaParameters;
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        return null;
    }
}

