/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.stepping.DebuggerSteppingHelper;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ \u0010\u0003\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tJ(\u0010\u000e\u001a\b\u0018\u00010\u0004R\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSteppingCommandProvider;", "Lcom/intellij/debugger/impl/JvmSteppingCommandProvider;", "()V", "getStepOutCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$ResumeCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "debugContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "stepSize", "", "getStepOverCommand", "ignoreBreakpoints", "", "kotlin.jvm-debugger.core"})
public final class KotlinSteppingCommandProvider
extends JvmSteppingCommandProvider {
    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOverCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"suspendContext.debugProcess");
        DebuggerContextImpl debuggerContextImpl = debugProcessImpl.getDebuggerContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"suspendContext.debugProcess.debuggerContext");
        SourcePosition sourcePosition2 = debuggerContextImpl.getSourcePosition();
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        return this.getStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition3);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOverCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @NotNull SourcePosition sourcePosition2) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
        return DebuggerSteppingHelper.createStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition2);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOutCommand(@NotNull SuspendContextImpl suspendContext, @NotNull DebuggerContextImpl debugContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)debugContext, (String)"debugContext");
        SourcePosition sourcePosition2 = debugContext.getSourcePosition();
        Intrinsics.checkNotNullExpressionValue((Object)sourcePosition2, (String)"debugContext.sourcePosition");
        return this.getStepOutCommand(suspendContext, sourcePosition2);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOutCommand(@Nullable SuspendContextImpl suspendContext, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"suspendContext.debugProcess");
        DebuggerContextImpl debuggerContextImpl = debugProcessImpl.getDebuggerContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"suspendContext.debugProcess.debuggerContext");
        SourcePosition sourcePosition2 = debuggerContextImpl.getSourcePosition();
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        return this.getStepOutCommand(suspendContext, sourcePosition3);
    }

    private final DebugProcessImpl.ResumeCommand getStepOutCommand(SuspendContextImpl suspendContext, SourcePosition sourcePosition2) {
        if (sourcePosition2.getLine() < 0) {
            return null;
        }
        return DebuggerSteppingHelper.createStepOutCommand(suspendContext, true);
    }
}

