/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.konan.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.konan.gradle.KonanModel;
import org.jetbrains.konan.gradle.KonanProjectResolver;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001ag\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032Q\u0010\u0004\u001aM\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00010\u0005H\u0086\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000f"}, d2={"forEachKonanProject", "", "project", "Lcom/intellij/openapi/project/Project;", "consumer", "Lkotlin/Function3;", "Lorg/jetbrains/konan/gradle/KonanModel;", "Lkotlin/ParameterName;", "name", "konanModel", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "moduleNode", "", "rootProjectPath", "kotlin-ultimate.common-cidr-native"})
public final class UtilsKt {
    public static final void forEachKonanProject(@NotNull Project project, @NotNull Function3<? super KonanModel, ? super DataNode<ModuleData>, ? super String, Unit> consumer) {
        int $i$f$forEachKonanProject = 0;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterator iterator = ProjectDataManager.getInstance().getExternalProjectsData(project, GradleConstants.SYSTEM_ID).iterator();
        while (iterator.hasNext()) {
            Collection modulesNodes;
            DataNode projectStructure;
            ExternalProjectInfo projectInfo;
            ExternalProjectInfo externalProjectInfo = projectInfo = (ExternalProjectInfo)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)externalProjectInfo, (String)"projectInfo");
            if (externalProjectInfo.getExternalProjectStructure() == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)projectStructure, (String)"projectInfo.externalProjectStructure ?: continue");
            Object object = projectStructure.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectStructure.data");
            ProjectData projectData = (ProjectData)object;
            Intrinsics.checkNotNullExpressionValue((Object)projectData.getLinkedExternalProjectPath(), (String)"projectData.linkedExternalProjectPath");
            Intrinsics.checkNotNullExpressionValue((Object)ExternalSystemApiUtil.findAll((DataNode)projectStructure, (Key)ProjectKeys.MODULE), (String)"ExternalSystemApiUtil.fi\u2026ture, ProjectKeys.MODULE)");
            for (DataNode moduleNode : modulesNodes) {
                String rootProjectPath;
                DataNode projectNode;
                if (ExternalSystemApiUtil.find((DataNode)moduleNode, KonanProjectResolver.Companion.getKONAN_MODEL_KEY()) == null) {
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)projectNode, (String)"ExternalSystemApiUtil.fi\u2026AN_MODEL_KEY) ?: continue");
                Object object2 = projectNode.getData();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"projectNode.data");
                KonanModel konanProject = (KonanModel)object2;
                DataNode dataNode = moduleNode;
                Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"moduleNode");
                consumer.invoke((Object)konanProject, (Object)dataNode, (Object)rootProjectPath);
            }
        }
    }
}

