/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchExecutionSession;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutput;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputType;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\b\u0010\u0013\u001a\u00020\u000fH\u0016J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\r*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J$\u0010\u0014\u001a\u0004\u0018\u00010\r*\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExecutor;", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;)V", "session", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession;", "checkForErrors", "", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "execute", "", "parseOutput", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "stop", "findExpression", "psiElement", "Lcom/intellij/psi/PsiElement;", "lineStart", "", "lineEnd", "ProcessOutputParser", "kotlin.jvm"})
public final class KtCompilingExecutor
extends ScratchExecutor {
    private KtScratchExecutionSession session;

    @Override
    public void execute() {
        block0: {
            this.getHandler().clear(this.getFile());
            this.getHandler().onStart(this.getFile());
            KtScratchExecutionSession ktScratchExecutionSession = this.session = new KtScratchExecutionSession(this.getFile(), this);
            if (ktScratchExecutionSession == null) break block0;
            ktScratchExecutionSession.execute((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ KtCompilingExecutor this$0;

                public final void invoke() {
                    KtCompilingExecutor.access$getHandler$p(this.this$0).onFinish(KtCompilingExecutor.access$getFile$p(this.this$0));
                    KtCompilingExecutor.access$setSession$p(this.this$0, null);
                }
                {
                    this.this$0 = ktCompilingExecutor;
                    super(0);
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.session == null) {
            return;
        }
        try {
            KtScratchExecutionSession ktScratchExecutionSession = this.session;
            if (ktScratchExecutionSession != null) {
                ktScratchExecutionSession.stop();
            }
        }
        finally {
            this.getHandler().onFinish(this.getFile());
        }
    }

    public final boolean checkForErrors(@NotNull KtFile psiFile2, @NotNull List<ScratchExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(this, psiFile2, expressions){
            final /* synthetic */ KtCompilingExecutor this$0;
            final /* synthetic */ KtFile $psiFile;
            final /* synthetic */ List $expressions;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void $this$filterTo$iv$iv;
                try {
                    AnalyzingUtils.checkForSyntacticErrors((PsiElement)((PsiElement)this.$psiFile));
                }
                catch (IllegalArgumentException e) {
                    String string = e.getMessage();
                    if (string == null) {
                        Object[] objectArray = new Object[1];
                        String string2 = this.$psiFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiFile.name");
                        objectArray[0] = string2;
                        string = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
                    }
                    ScratchExecutor.errorOccurs$default(this.this$0, string, null, true, 2, null);
                    return false;
                }
                AnalysisResult analysisResult = ResolutionUtils.analyzeWithAllCompilerChecks((KtFile)this.$psiFile, (KtFile[])new KtFile[0]);
                if (analysisResult.isError()) {
                    String string = analysisResult.getError().getMessage();
                    if (string == null) {
                        Object[] objectArray = new Object[1];
                        String string3 = this.$psiFile.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"psiFile.name");
                        objectArray[0] = string3;
                        string = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
                    }
                    ScratchExecutor.errorOccurs$default(this.this$0, string, null, true, 2, null);
                    return false;
                }
                BindingContext bindingContext = analysisResult.getBindingContext();
                Diagnostics diagnostics = bindingContext.getDiagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"bindingContext.diagnostics");
                Iterable $this$filter$iv = (Iterable)diagnostics;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Diagnostic it = (Diagnostic)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getSeverity() == Severity.ERROR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List diagnostics2 = (List)destination$iv$iv;
                $this$filter$iv = diagnostics2;
                $i$f$filter = false;
                if (!$this$filter$iv.isEmpty()) {
                    PsiFile scratchPsiFile = KtCompilingExecutor.access$getFile$p(this.this$0).getPsiFile();
                    Iterable $this$forEach$iv = diagnostics2;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        String errorText;
                        Diagnostic diagnostic = (Diagnostic)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)DefaultErrorMessages.render((Diagnostic)diagnostic), (String)"DefaultErrorMessages.render(diagnostic)");
                        if (Intrinsics.areEqual((Object)this.$psiFile, (Object)scratchPsiFile)) {
                            PsiElement psiElement = diagnostic.getPsiElement();
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"diagnostic.psiElement");
                            if (Intrinsics.areEqual((Object)psiElement.getContainingFile(), (Object)this.$psiFile)) {
                                PsiElement psiElement2 = diagnostic.getPsiElement();
                                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"diagnostic.psiElement");
                                ScratchExpression scratchExpression = KtCompilingExecutor.access$findExpression(this.this$0, this.$expressions, psiElement2);
                                if (scratchExpression == null) {
                                    Logger logger = ScratchUtilsKt.getLOG();
                                    StringBuilder stringBuilder = new StringBuilder().append("Couldn't find expression to report error: ");
                                    PsiElement psiElement3 = diagnostic.getPsiElement();
                                    Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"diagnostic.psiElement");
                                    logger.error(stringBuilder.append(PsiUtilsKt.getElementTextWithContext((PsiElement)psiElement3)).toString());
                                    KtCompilingExecutor.access$getHandler$p(this.this$0).error(KtCompilingExecutor.access$getFile$p(this.this$0), errorText);
                                    continue;
                                }
                                KtCompilingExecutor.access$getHandler$p(this.this$0).handle(KtCompilingExecutor.access$getFile$p(this.this$0), scratchExpression, new ScratchOutput(errorText, ScratchOutputType.ERROR));
                                continue;
                            }
                            KtCompilingExecutor.access$getHandler$p(this.this$0).error(KtCompilingExecutor.access$getFile$p(this.this$0), errorText);
                            continue;
                        }
                        KtCompilingExecutor.access$getHandler$p(this.this$0).error(KtCompilingExecutor.access$getFile$p(this.this$0), errorText);
                    }
                    KtCompilingExecutor.access$getHandler$p(this.this$0).onFinish(KtCompilingExecutor.access$getFile$p(this.this$0));
                    return false;
                }
                return true;
            }
            {
                this.this$0 = ktCompilingExecutor;
                this.$psiFile = ktFile;
                this.$expressions = list;
                super(0);
            }
        }));
    }

    public final void parseOutput(@NotNull ProcessOutput processOutput, @NotNull List<ScratchExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        new ProcessOutputParser(expressions).parse(processOutput);
    }

    private final ScratchExpression findExpression(List<ScratchExpression> $this$findExpression, PsiElement psiElement) {
        int elementLine = KotlinRefactoringUtilKt.getLineNumber$default((PsiElement)psiElement, (boolean)false, (int)1, null);
        return (ScratchExpression)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<ScratchExpression>($this$findExpression, elementLine){
            final /* synthetic */ List $this_findExpression;
            final /* synthetic */ int $elementLine;

            @Nullable
            public final ScratchExpression invoke() {
                Object v0;
                block1: {
                    Iterable $this$firstOrNull$iv = this.$this_findExpression;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        ScratchExpression it = (ScratchExpression)element$iv;
                        boolean bl = false;
                        int n = this.$elementLine;
                        if (!(it.getLineStart() <= n && it.getLineEnd() >= n)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
            {
                this.$this_findExpression = list;
                this.$elementLine = n;
                super(0);
            }
        }));
    }

    private final ScratchExpression findExpression(List<ScratchExpression> $this$findExpression, int lineStart, int lineEnd) {
        return (ScratchExpression)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<ScratchExpression>($this$findExpression, lineStart, lineEnd){
            final /* synthetic */ List $this_findExpression;
            final /* synthetic */ int $lineStart;
            final /* synthetic */ int $lineEnd;

            @Nullable
            public final ScratchExpression invoke() {
                Object v0;
                block1: {
                    Iterable $this$firstOrNull$iv = this.$this_findExpression;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        ScratchExpression it = (ScratchExpression)element$iv;
                        boolean bl = false;
                        if (!(it.getLineStart() == this.$lineStart && it.getLineEnd() == this.$lineEnd)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
            {
                this.$this_findExpression = list;
                this.$lineStart = n;
                this.$lineEnd = n2;
                super(0);
            }
        }));
    }

    public KtCompilingExecutor(@NotNull ScratchFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(file);
    }

    public static final /* synthetic */ KtScratchExecutionSession access$getSession$p(KtCompilingExecutor $this) {
        return $this.session;
    }

    public static final /* synthetic */ void access$setSession$p(KtCompilingExecutor $this, KtScratchExecutionSession ktScratchExecutionSession) {
        $this.session = ktScratchExecutionSession;
    }

    public static final /* synthetic */ ScratchExpression access$findExpression(KtCompilingExecutor $this, List $this$access_u24findExpression, PsiElement psiElement) {
        return $this.findExpression($this$access_u24findExpression, psiElement);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor$ProcessOutputParser;", "", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "(Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;Ljava/util/List;)V", "extractLineInfoFrom", "Lkotlin/Pair;", "", "encoded", "", "isGeneratedOutput", "", "line", "isOutputEnd", "isResultEnd", "parse", "", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "parseStdOut", "out", "kotlin.jvm"})
    private final class ProcessOutputParser {
        private final List<ScratchExpression> expressions;

        public final void parse(@NotNull ProcessOutput processOutput) {
            Intrinsics.checkNotNullParameter((Object)processOutput, (String)"processOutput");
            String string = processOutput.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processOutput.stdout");
            String out = string;
            String string2 = processOutput.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"processOutput.stderr");
            String err = string2;
            CharSequence charSequence = err;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                KtCompilingExecutor.this.getHandler().error(KtCompilingExecutor.this.getFile(), err);
            }
            charSequence = out;
            bl = false;
            if (!StringsKt.isBlank((CharSequence)charSequence)) {
                this.parseStdOut(out);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void parseStdOut(String out) {
            boolean bl = false;
            ArrayList<String> results = new ArrayList<String>();
            boolean bl2 = false;
            ArrayList<String> userOutput = new ArrayList<String>();
            for (String line : StringsKt.split$default((CharSequence)out, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null)) {
                ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Compiling executor output: " + line);
                if (this.isOutputEnd(line)) {
                    return;
                }
                if (this.isGeneratedOutput(line)) {
                    String lineWoPrefix = StringsKt.removePrefix((String)line, (CharSequence)"##scratch##generated##");
                    if (this.isResultEnd(lineWoPrefix)) {
                        void startLine;
                        Pair<Integer, Integer> extractedLineInfo;
                        if (this.extractLineInfoFrom(lineWoPrefix) == null) {
                            ScratchExecutor.errorOccurs$default(KtCompilingExecutor.this, KotlinJvmBundle.message("couldn.t.extract.line.info.from.line.0", lineWoPrefix), null, true, 2, null);
                            return;
                        }
                        Pair<Integer, Integer> pair = extractedLineInfo;
                        int n = ((Number)pair.component1()).intValue();
                        int endLine = ((Number)pair.component2()).intValue();
                        ScratchExpression scratchExpression = KtCompilingExecutor.this.findExpression(this.expressions, (int)startLine, endLine);
                        if (scratchExpression == null) {
                            ScratchUtilsKt.getLOG().error("Couldn't find expression with start line = " + (int)startLine + ", end line = " + endLine + ".\n" + CollectionsKt.joinToString$default((Iterable)this.expressions, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                        } else {
                            Iterable $this$forEach$iv = userOutput;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String output = (String)element$iv;
                                boolean bl3 = false;
                                KtCompilingExecutor.this.getHandler().handle(KtCompilingExecutor.this.getFile(), scratchExpression, new ScratchOutput(output, ScratchOutputType.OUTPUT));
                            }
                            $this$forEach$iv = results;
                            $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                String result = (String)element$iv;
                                boolean bl4 = false;
                                KtCompilingExecutor.this.getHandler().handle(KtCompilingExecutor.this.getFile(), scratchExpression, new ScratchOutput(result, ScratchOutputType.RESULT));
                            }
                        }
                        boolean bl5 = false;
                        results = new ArrayList();
                        bl5 = false;
                        userOutput = new ArrayList();
                        continue;
                    }
                    if (!(Intrinsics.areEqual((Object)lineWoPrefix, (Object)Unit.INSTANCE.toString()) ^ true)) continue;
                    results.add(lineWoPrefix);
                    continue;
                }
                userOutput.add(line);
            }
        }

        private final boolean isOutputEnd(String line) {
            return Intrinsics.areEqual((Object)StringsKt.removeSuffix((String)line, (CharSequence)"\n"), (Object)"end##!@#%^&*");
        }

        private final boolean isResultEnd(String line) {
            return StringsKt.startsWith$default((String)line, (String)"end##", (boolean)false, (int)2, null);
        }

        private final boolean isGeneratedOutput(String line) {
            return StringsKt.startsWith$default((String)line, (String)"##scratch##generated##", (boolean)false, (int)2, null);
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> extractLineInfoFrom(String encoded) {
            List lineInfo = StringsKt.split$default((CharSequence)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)encoded, (CharSequence)"end##"), (CharSequence)"\n"), (char[])new char[]{'|'}, (boolean)false, (int)0, (int)6, null);
            if (lineInfo.size() == 2) {
                try {
                    void a;
                    String string = (String)lineInfo.get(0);
                    boolean bl = false;
                    Integer n = Integer.parseInt(string);
                    string = (String)lineInfo.get(1);
                    bl = false;
                    Pair pair = TuplesKt.to((Object)n, (Object)Integer.parseInt(string));
                    int n2 = ((Number)pair.component1()).intValue();
                    int b = ((Number)pair.component2()).intValue();
                    if (a > -1 && b > -1) {
                        return TuplesKt.to((Object)((int)a), (Object)b);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        public ProcessOutputParser(List<ScratchExpression> expressions) {
            Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
            this.expressions = expressions;
        }
    }
}

