/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.disambiguation.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.languagetool.AnalyzedToken;
import org.languagetool.Languages;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.XMLRuleHandler;
import org.languagetool.tagging.disambiguation.rules.DisambiguatedExample;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DisambiguationRuleHandler
extends XMLRuleHandler {
    private static final String WD = "wd";
    private static final String ACTION = "action";
    private static final String DISAMBIG = "disambig";
    private final List<DisambiguationPatternRule> rules = new ArrayList<DisambiguationPatternRule>();
    private boolean inDisambiguation;
    private int subId;
    private String name;
    private String ruleGroupId;
    private String ruleGroupName;
    protected String filterClassName;
    protected String filterArgs;
    private StringBuilder disamb = new StringBuilder();
    private StringBuilder wd = new StringBuilder();
    private StringBuilder example = new StringBuilder();
    private int antiPatternCounter = 0;
    private boolean inRule;
    private List<DisambiguationPatternRule> rulegroupAntiPatterns = new ArrayList<DisambiguationPatternRule>();
    private List<DisambiguationPatternRule> ruleAntiPatterns = new ArrayList<DisambiguationPatternRule>();
    private boolean inAntiPattern;
    private boolean inWord;
    private String disambiguatedPOS;
    private int startPos = -1;
    private int endPos = -1;
    private int tokenCountForMarker;
    private Match posSelector;
    private int uniCounter;
    private List<AnalyzedToken> newWdList;
    private String wdLemma;
    private String wdPos;
    private boolean inExample;
    private boolean untouched;
    private List<String> untouchedExamples;
    private List<DisambiguatedExample> disambExamples;
    private String input;
    private String output;
    private DisambiguationPatternRule.DisambiguatorAction disambigAction;

    DisambiguationRuleHandler() {
    }

    List<DisambiguationPatternRule> getDisambRules() {
        return this.rules;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        switch (qName) {
            case "rule": {
                this.inRule = true;
                this.id = attrs.getValue("id");
                if (this.inRuleGroup) {
                    ++this.subId;
                }
                this.name = attrs.getValue("name");
                if (this.inRuleGroup && this.id == null) {
                    this.id = this.ruleGroupId;
                }
                if (!this.inRuleGroup || this.name != null) break;
                this.name = this.ruleGroupName;
                break;
            }
            case "rules": {
                this.language = Languages.getLanguageForShortCode(attrs.getValue("lang"));
                break;
            }
            case "pattern": {
                this.inPattern = true;
                this.tokenCountForMarker = 0;
                if (attrs.getValue("case_sensitive") == null || !"yes".equals(attrs.getValue("case_sensitive"))) break;
                this.caseSensitive = true;
                break;
            }
            case "antipattern": {
                this.inAntiPattern = true;
                ++this.antiPatternCounter;
                this.caseSensitive = "yes".equals(attrs.getValue("case_sensitive"));
                this.tokenCounter = 0;
                this.tokenCountForMarker = 0;
                break;
            }
            case "exception": {
                this.setExceptions(attrs);
                break;
            }
            case "and": {
                this.inAndGroup = true;
                ++this.tokenCountForMarker;
                if (!this.inUnification) break;
                ++this.uniCounter;
                break;
            }
            case "unify": {
                this.inUnification = true;
                this.uniNegation = "yes".equals(attrs.getValue("negate"));
                this.uniCounter = 0;
                break;
            }
            case "unify-ignore": {
                this.inUnificationNeutral = true;
                break;
            }
            case "feature": {
                this.uFeature = attrs.getValue("id");
                break;
            }
            case "type": {
                this.uType = attrs.getValue("id");
                this.uTypeList.add(this.uType);
                break;
            }
            case "token": {
                this.setToken(attrs);
                if (this.inAndGroup) break;
                ++this.tokenCountForMarker;
                break;
            }
            case "disambig": {
                this.inDisambiguation = true;
                this.disambiguatedPOS = attrs.getValue("postag");
                this.disambigAction = attrs.getValue(ACTION) == null ? DisambiguationPatternRule.DisambiguatorAction.REPLACE : DisambiguationPatternRule.DisambiguatorAction.valueOf(attrs.getValue(ACTION).toUpperCase(Locale.ENGLISH));
                this.disamb = new StringBuilder();
                break;
            }
            case "match": {
                this.inMatch = true;
                this.match = new StringBuilder();
                Match.CaseConversion caseConversion = Match.CaseConversion.NONE;
                if (attrs.getValue("case_conversion") != null) {
                    caseConversion = Match.CaseConversion.valueOf(attrs.getValue("case_conversion").toUpperCase(Locale.ENGLISH));
                }
                Match.IncludeRange includeRange = Match.IncludeRange.NONE;
                if (attrs.getValue("include_skipped") != null) {
                    includeRange = Match.IncludeRange.valueOf(attrs.getValue("include_skipped").toUpperCase(Locale.ENGLISH));
                }
                Match mWorker = new Match(attrs.getValue("postag"), attrs.getValue("postag_replace"), "yes".equals(attrs.getValue("postag_regexp")), attrs.getValue("regexp_match"), attrs.getValue("regexp_replace"), caseConversion, "yes".equals(attrs.getValue("setpos")), "yes".equals(attrs.getValue("suppress_mispelled")), includeRange);
                if (this.inDisambiguation) {
                    if (attrs.getValue("no") == null) break;
                    int refNumber = Integer.parseInt(attrs.getValue("no"));
                    this.refNumberSanityCheck(refNumber);
                    mWorker.setTokenRef(refNumber);
                    this.posSelector = mWorker;
                    break;
                }
                if (!this.inToken || attrs.getValue("no") == null) break;
                int refNumber = Integer.parseInt(attrs.getValue("no"));
                this.refNumberSanityCheck(refNumber);
                mWorker.setTokenRef(refNumber);
                this.tokenReference = mWorker;
                this.elements.append('\\');
                this.elements.append(refNumber);
                break;
            }
            case "rulegroup": {
                this.ruleGroupId = attrs.getValue("id");
                this.ruleGroupName = attrs.getValue("name");
                this.inRuleGroup = true;
                this.subId = 0;
                if (this.rulegroupAntiPatterns != null) {
                    this.rulegroupAntiPatterns.clear();
                }
                this.antiPatternCounter = 0;
                break;
            }
            case "unification": {
                this.uFeature = attrs.getValue("feature");
                this.inUnificationDef = true;
                break;
            }
            case "equivalence": {
                this.uType = attrs.getValue("type");
                break;
            }
            case "wd": {
                this.wdLemma = attrs.getValue("lemma");
                this.wdPos = attrs.getValue("pos");
                this.inWord = true;
                this.wd = new StringBuilder();
                break;
            }
            case "example": {
                this.inExample = true;
                if (this.untouchedExamples == null) {
                    this.untouchedExamples = new ArrayList<String>();
                }
                if (this.disambExamples == null) {
                    this.disambExamples = new ArrayList<DisambiguatedExample>();
                }
                this.untouched = attrs.getValue("type").equals("untouched");
                if (attrs.getValue("type").equals("ambiguous")) {
                    this.input = attrs.getValue("inputform");
                    this.output = attrs.getValue("outputform");
                }
                this.example = new StringBuilder();
                break;
            }
            case "filter": {
                this.filterClassName = attrs.getValue("class");
                this.filterArgs = attrs.getValue("args");
                break;
            }
            case "marker": {
                this.example.append("<marker>");
                if (!this.inPattern && !this.inAntiPattern) break;
                this.startPos = this.tokenCounter;
                this.inMarker = true;
            }
        }
    }

    private void refNumberSanityCheck(int refNumber) throws SAXException {
        if (refNumber > this.patternTokens.size()) {
            throw new SAXException("Only backward references in match elements are possible, tried to specify token " + refNumber + "\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        switch (qName) {
            case "rule": {
                boolean singleTokenCorrection;
                DisambiguationPatternRule rule = new DisambiguationPatternRule(this.id, this.name, this.language, this.patternTokens, this.disambiguatedPOS, this.posSelector, this.disambigAction);
                this.endPositionCorrection = this.endPos - this.tokenCountForMarker;
                if (this.startPos != -1 && this.endPos != -1) {
                    rule.setStartPositionCorrection(this.startPos);
                    rule.setEndPositionCorrection(this.endPositionCorrection);
                } else {
                    this.startPos = 0;
                    this.endPos = this.tokenCountForMarker;
                }
                rule.setSubId(this.inRuleGroup ? Integer.toString(this.subId) : "1");
                int matchedTokenCount = this.endPos - this.startPos;
                if (this.newWdList != null) {
                    if (this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.ADD || this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.REMOVE || this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.REPLACE) {
                        if (!this.newWdList.isEmpty() && this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.REPLACE && this.newWdList.size() != matchedTokenCount) {
                            throw new SAXException(this.language.getName() + " rule error. The number of interpretations specified with wd: " + this.newWdList.size() + " must be equal to the number of matched tokens (" + matchedTokenCount + ")\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
                        }
                        rule.setNewInterpretations(this.newWdList.toArray(new AnalyzedToken[0]));
                    }
                    this.newWdList.clear();
                }
                this.caseSensitive = false;
                if (this.disambExamples != null) {
                    rule.setExamples(this.disambExamples);
                }
                if (this.untouchedExamples != null) {
                    rule.setUntouchedExamples(this.untouchedExamples);
                }
                this.setRuleFilter(this.filterClassName, this.filterArgs, rule);
                if (!this.rulegroupAntiPatterns.isEmpty()) {
                    rule.setAntiPatterns(this.rulegroupAntiPatterns);
                }
                if (!this.ruleAntiPatterns.isEmpty()) {
                    rule.setAntiPatterns(this.ruleAntiPatterns);
                    this.ruleAntiPatterns.clear();
                }
                this.rules.add(rule);
                if (this.disambigAction == DisambiguationPatternRule.DisambiguatorAction.UNIFY && matchedTokenCount != this.uniCounter) {
                    throw new SAXException(this.language.getName() + " rule error. The number unified tokens: " + this.uniCounter + " must be equal to the number of matched tokens: " + matchedTokenCount + "\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
                }
                boolean bl = singleTokenCorrection = this.endPos - this.startPos > 1;
                if (!(singleTokenCorrection || this.disambigAction != DisambiguationPatternRule.DisambiguatorAction.FILTER && this.disambigAction != DisambiguationPatternRule.DisambiguatorAction.REPLACE || matchedTokenCount <= 1)) {
                    throw new SAXException(this.language.getName() + " rule error. Cannot replace or filter more than one token at a time.\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
                }
                this.patternTokens.clear();
                this.posSelector = null;
                this.disambExamples = null;
                this.untouchedExamples = null;
                this.startPos = -1;
                this.endPos = -1;
                this.filterClassName = null;
                this.filterArgs = null;
                this.inRule = false;
                break;
            }
            case "exception": {
                this.finalizeExceptions();
                break;
            }
            case "and": {
                this.inAndGroup = false;
                this.andGroupCounter = 0;
                ++this.tokenCounter;
                break;
            }
            case "token": {
                if (!this.exceptionSet || this.patternToken == null) {
                    boolean tokenCase = this.caseSensitive;
                    if (this.tokenLevelCaseSet) {
                        tokenCase = this.tokenLevelCaseSensitive;
                    }
                    this.patternToken = new PatternToken(this.elements.toString(), tokenCase, this.regExpression, this.tokenInflected);
                    this.patternToken.setNegation(this.tokenNegated);
                } else {
                    this.patternToken.setStringElement(this.elements.toString());
                }
                if (this.skipPos != 0) {
                    this.patternToken.setSkipNext(this.skipPos);
                    this.skipPos = 0;
                }
                if (this.minOccurrence == 0) {
                    this.patternToken.setMinOccurrence(0);
                }
                if (this.maxOccurrence != 1) {
                    this.patternToken.setMaxOccurrence(this.maxOccurrence);
                    this.maxOccurrence = 1;
                }
                if (this.posToken != null) {
                    this.patternToken.setPosToken(new PatternToken.PosToken(this.posToken, this.posRegExp, this.posNegation));
                    this.posToken = null;
                }
                if (this.chunkTag != null) {
                    this.patternToken.setChunkTag(this.chunkTag);
                    this.chunkTag = null;
                }
                if (this.tokenReference != null) {
                    this.patternToken.setMatch(this.tokenReference);
                }
                if (this.inAndGroup && this.andGroupCounter > 0) {
                    ((PatternToken)this.patternTokens.get(this.patternTokens.size() - 1)).setAndGroupElement(this.patternToken);
                    if (this.minOccurrence != 1 || this.maxOccurrence != 1) {
                        throw new SAXException("Please set min and max attributes on the first token in the AND group.\n You attempted to set these attributes on the token no. " + (this.andGroupCounter + 1) + ".\n Line: " + this.pLocator.getLineNumber() + ", column: " + this.pLocator.getColumnNumber() + ".");
                    }
                } else {
                    if (this.minOccurrence < 1) {
                        this.patternTokens.add(this.patternToken);
                    }
                    for (int i = 1; i <= this.minOccurrence; ++i) {
                        this.patternTokens.add(this.patternToken);
                    }
                    this.minOccurrence = 1;
                }
                if (this.inAndGroup) {
                    ++this.andGroupCounter;
                }
                if (this.inUnification) {
                    this.patternToken.setUnification(this.equivalenceFeatures);
                    if (!this.inAndGroup) {
                        ++this.uniCounter;
                    }
                    if (this.inUnificationNeutral) {
                        this.patternToken.setUnificationNeutral();
                    }
                }
                if (this.inUnificationDef) {
                    this.language.getDisambiguationUnifierConfiguration().setEquivalence(this.uFeature, this.uType, this.patternToken);
                    this.patternTokens.clear();
                }
                this.patternToken.setInsideMarker(this.inMarker);
                if (this.tokenSpaceBeforeSet) {
                    this.patternToken.setWhitespaceBefore(this.tokenSpaceBefore);
                }
                this.resetToken();
                break;
            }
            case "pattern": {
                this.inPattern = false;
                this.tokenCounter = 0;
                break;
            }
            case "match": {
                if (this.inDisambiguation) {
                    this.posSelector.setLemmaString(this.match.toString());
                } else if (this.inToken) {
                    this.tokenReference.setLemmaString(this.match.toString());
                }
                this.inMatch = false;
                break;
            }
            case "disambig": {
                this.inDisambiguation = false;
                break;
            }
            case "rulegroup": {
                this.inRuleGroup = false;
                break;
            }
            case "unification": {
                if (!this.inUnificationDef) break;
                this.inUnificationDef = false;
                this.tokenCounter = 0;
                break;
            }
            case "feature": {
                this.equivalenceFeatures.put(this.uFeature, this.uTypeList);
                this.uTypeList = new ArrayList();
                break;
            }
            case "unify": {
                this.inUnification = false;
                this.equivalenceFeatures = new HashMap();
                int lastElement = this.patternTokens.size() - 1;
                ((PatternToken)this.patternTokens.get(lastElement)).setLastInUnification();
                if (!this.uniNegation) break;
                ((PatternToken)this.patternTokens.get(lastElement)).setUniNegation();
                break;
            }
            case "unify-ignore": {
                this.inUnificationNeutral = false;
                break;
            }
            case "wd": {
                this.addNewWord(this.wd.toString(), this.wdLemma, this.wdPos);
                this.inWord = false;
                break;
            }
            case "antipattern": {
                DisambiguationPatternRule disRule = new DisambiguationPatternRule(this.id + "_antipattern:" + this.antiPatternCounter, "antipattern", this.language, this.patternTokens, null, null, DisambiguationPatternRule.DisambiguatorAction.IMMUNIZE);
                if (this.startPos != -1 && this.endPos != -1) {
                    disRule.setStartPositionCorrection(this.startPos);
                    disRule.setEndPositionCorrection(this.endPos - this.tokenCountForMarker);
                }
                this.patternTokens.clear();
                if (this.inRule) {
                    if (this.ruleAntiPatterns == null) {
                        this.ruleAntiPatterns = new ArrayList<DisambiguationPatternRule>();
                    }
                    this.ruleAntiPatterns.add(disRule);
                } else {
                    if (this.rulegroupAntiPatterns == null) {
                        this.rulegroupAntiPatterns = new ArrayList<DisambiguationPatternRule>();
                    }
                    this.rulegroupAntiPatterns.add(disRule);
                }
                this.tokenCounter = 0;
                this.inAntiPattern = false;
                break;
            }
            case "example": {
                this.inExample = false;
                if (this.untouched) {
                    this.untouchedExamples.add(this.example.toString());
                    break;
                }
                this.disambExamples.add(new DisambiguatedExample(this.example.toString(), this.input, this.output));
                break;
            }
            case "marker": {
                this.example.append("</marker>");
                if (!this.inPattern && !this.inAntiPattern) break;
                this.endPos = this.tokenCountForMarker;
                this.inMarker = false;
            }
        }
    }

    private void addNewWord(String word, String lemma, String pos) {
        AnalyzedToken newWd = new AnalyzedToken(word, pos, lemma);
        if (this.newWdList == null) {
            this.newWdList = new ArrayList<AnalyzedToken>();
        }
        this.newWdList.add(newWd);
    }

    @Override
    public final void characters(char[] buf, int offset, int len) {
        String s = new String(buf, offset, len);
        if (this.inException) {
            this.exceptions.append(s);
        } else if (this.inToken && (this.inPattern || this.inAntiPattern)) {
            this.elements.append(s);
        } else if (this.inMatch) {
            this.match.append(s);
        } else if (this.inWord) {
            this.wd.append(s);
        } else if (this.inDisambiguation) {
            this.disamb.append(s);
        } else if (this.inExample) {
            this.example.append(s);
        }
    }
}

