/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntCreatePropertyFix
implements LocalQuickFix {
    @NonNls
    private static final String PROPERTY = "property";
    @NonNls
    private static final String NAME_ATTR = "name";
    @NonNls
    private static final String VALUE_ATTR = "value";
    @NlsSafe
    private final String myCanonicalText;
    @Nullable
    private final PropertiesFile myPropFile;

    public AntCreatePropertyFix(@NlsSafe String canonicalText, @Nullable PropertiesFile propertiesFile) {
        this.myCanonicalText = canonicalText;
        this.myPropFile = propertiesFile;
    }

    @NotNull
    public String getName() {
        if (this.myPropFile != null) {
            String string = AntBundle.message("create.property.in.file.quickfix.name", this.myCanonicalText, this.myPropFile.getName());
            if (string == null) {
                AntCreatePropertyFix.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = AntBundle.message("create.property.quickfix.name", this.myCanonicalText);
        if (string == null) {
            AntCreatePropertyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = AntBundle.message("ant.intention.create.property.family.name", new Object[0]);
        if (string == null) {
            AntCreatePropertyFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AntCreatePropertyFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AntCreatePropertyFix.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiFile containingFile = psiElement.getContainingFile();
        FileModificationService modificationService = FileModificationService.getInstance();
        Navigatable result = null;
        if (this.myPropFile != null) {
            VirtualFile vFile = this.myPropFile.getVirtualFile();
            if (this.myPropFile instanceof PsiFile ? !modificationService.prepareFileForWrite((PsiFile)this.myPropFile) : vFile != null && !modificationService.prepareVirtualFilesForWrite(project, Collections.singleton(vFile))) {
                return;
            }
            result = (Navigatable)WriteAction.compute(() -> {
                IProperty generatedProperty = this.myPropFile.addProperty(this.myCanonicalText, "");
                return vFile != null ? PsiNavigationSupport.getInstance().createNavigatable(project, vFile, generatedProperty.getPsiElement().getTextRange().getEndOffset()) : generatedProperty;
            });
        } else if (containingFile instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)containingFile;
            XmlTag rootTag = xmlFile.getRootTag();
            if (!modificationService.prepareFileForWrite((PsiFile)xmlFile)) {
                return;
            }
            if (rootTag != null) {
                result = (Navigatable)WriteAction.compute(() -> {
                    XmlAttributeValue valueElement;
                    XmlAttribute valueAttrib;
                    Object generated;
                    XmlTag propTag = rootTag.createChildTag(PROPERTY, rootTag.getNamespace(), null, false);
                    propTag.setAttribute(NAME_ATTR, this.myCanonicalText);
                    propTag.setAttribute(VALUE_ATTR, "");
                    DomElement contextElement = DomUtil.getDomElement((PsiElement)descriptor.getPsiElement());
                    if (contextElement == null) {
                        generated = rootTag.addSubTag(propTag, true);
                    } else {
                        AntDomTarget containingTarget = (AntDomTarget)contextElement.getParentOfType(AntDomTarget.class, false);
                        AntDomTarget anchor = containingTarget != null ? containingTarget : contextElement;
                        XmlTag tag = anchor.getXmlTag();
                        generated = !rootTag.equals(tag) ? tag.getParent().addBefore((PsiElement)propTag, (PsiElement)tag) : rootTag.addSubTag(propTag, true);
                    }
                    Navigatable navigatable = null;
                    if (generated instanceof XmlTag && (valueAttrib = generated.getAttribute(VALUE_ATTR)) != null && (valueElement = valueAttrib.getValueElement()) instanceof Navigatable) {
                        navigatable = (Navigatable)valueElement;
                    }
                    if (navigatable == null && generated instanceof Navigatable) {
                        navigatable = (Navigatable)generated;
                    }
                    return navigatable;
                });
            }
        }
        if (result != null) {
            result.navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/quickfix/AntCreatePropertyFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/quickfix/AntCreatePropertyFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

