/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.execution.AntPathUtil;
import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.ant.execution.AntMain2;
import com.intellij.rt.ant.execution.IdeaAntLogger2;
import com.intellij.rt.ant.execution.IdeaInputHandler;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class AntCommandLineBuilder {
    private final List<@NlsSafe String> myTargets = new ArrayList<String>();
    private final JavaParameters myCommandLine = new JavaParameters();
    @NlsSafe
    private String myBuildFilePath;
    private List<BuildFileProperty> myProperties;
    private boolean myDone = false;
    @NonNls
    private final List<String> myExpandedProperties = new ArrayList<String>();
    @NonNls
    private static final String INPUT_HANDLER_PARAMETER = "-inputhandler";
    @NonNls
    private static final String LOGFILE_PARAMETER = "-logfile";
    @NonNls
    private static final String LOGFILE_SHORT_PARAMETER = "-l";
    @NonNls
    private static final String LOGGER_PARAMETER = "-logger";

    public void calculateProperties(DataContext dataContext, Project project, List<BuildFileProperty> additionalProperties) throws Macro.ExecutionCancelledException {
        for (BuildFileProperty property : this.myProperties) {
            this.expandProperty(dataContext, project, property);
        }
        for (BuildFileProperty property : additionalProperties) {
            this.expandProperty(dataContext, project, property);
        }
    }

    private void expandProperty(DataContext dataContext, Project project, BuildFileProperty property) throws Macro.ExecutionCancelledException {
        String value = property.getPropertyValue();
        MacroManager macroManager = GlobalAntConfiguration.getMacroManager();
        value = macroManager.expandMacrosInString(value, true, dataContext);
        value = macroManager.expandMacrosInString(value, false, dataContext);
        value = PathMacroManager.getInstance((ComponentManager)project).expandPath(value);
        this.myExpandedProperties.add("-D" + property.getPropertyName() + "=" + value);
    }

    public void addTarget(@NlsSafe String targetName) {
        this.myTargets.add(targetName);
    }

    public void setBuildFile(AbstractProperty.AbstractPropertyContainer container, File buildFile) throws CantRunException {
        String toolsJar;
        String jdkName = (String)AntBuildFileImpl.CUSTOM_JDK_NAME.get(container);
        if (!(jdkName != null && jdkName.length() > 0 || (jdkName = (String)AntConfigurationImpl.DEFAULT_JDK_NAME.get(container)) != null && jdkName.length() != 0)) {
            throw new CantRunException(AntBundle.message("project.jdk.not.specified.error.message", new Object[0]));
        }
        Sdk jdk = GlobalAntConfiguration.findJdk(jdkName);
        if (jdk == null) {
            throw new CantRunException(AntBundle.message("jdk.with.name.not.configured.error.message", jdkName));
        }
        VirtualFile homeDirectory = jdk.getHomeDirectory();
        if (homeDirectory == null) {
            throw new CantRunException(AntBundle.message("jdk.with.name.bad.configured.error.message", jdkName));
        }
        this.myCommandLine.setJdk(jdk);
        ParametersList vmParametersList = this.myCommandLine.getVMParametersList();
        vmParametersList.add("-Xmx" + AntBuildFileImpl.MAX_HEAP_SIZE.get(container) + "m");
        vmParametersList.add("-Xss" + AntBuildFileImpl.MAX_STACK_SIZE.get(container) + "m");
        AntInstallation antInstallation = (AntInstallation)AntBuildFileImpl.ANT_INSTALLATION.get(container);
        if (antInstallation == null) {
            throw new CantRunException(AntBundle.message("ant.installation.not.configured.error.message", new Object[0]));
        }
        String antHome = (String)AntInstallation.HOME_DIR.get(antInstallation.getProperties());
        vmParametersList.add("-Dant.home=" + antHome);
        String libraryDir = antHome + (antHome.endsWith("/") || antHome.endsWith(File.separator) ? "" : File.separator) + "lib";
        vmParametersList.add("-Dant.library.dir=" + libraryDir);
        String[] urls = jdk.getRootProvider().getUrls(OrderRootType.CLASSES);
        String jdkHome = homeDirectory.getPath().replace('/', File.separatorChar);
        @NonNls String pathToJre = jdkHome + File.separator + "jre" + File.separator;
        for (String url : urls) {
            String path = PathUtil.toPresentableUrl((String)url);
            if (path.startsWith(pathToJre)) continue;
            this.myCommandLine.getClassPath().add(path);
        }
        this.myCommandLine.getClassPath().addAllFiles((List)AntBuildFileImpl.ALL_CLASS_PATH.get(container));
        this.myCommandLine.getClassPath().addAllFiles(AntBuildFileImpl.getUserHomeLibraries());
        SdkTypeId sdkType = jdk.getSdkType();
        if (sdkType instanceof JavaSdkType && (toolsJar = ((JavaSdkType)sdkType).getToolsPath(jdk)) != null) {
            this.myCommandLine.getClassPath().add(toolsJar);
        }
        AntPathUtil.addRtJar(this.myCommandLine.getClassPath());
        this.myCommandLine.setMainClass(AntMain2.class.getName());
        ParametersList programParameters = this.myCommandLine.getProgramParametersList();
        String additionalParams = (String)AntBuildFileImpl.ANT_COMMAND_LINE_PARAMETERS.get(container);
        if (additionalParams != null) {
            for (String param : ParametersList.parse((String)additionalParams)) {
                if (param.startsWith("-J")) {
                    String cutParam = param.substring("-J".length());
                    if (cutParam.length() <= 0) continue;
                    vmParametersList.add(cutParam);
                    continue;
                }
                programParameters.add(param);
            }
        }
        if (!programParameters.getList().contains(LOGGER_PARAMETER)) {
            programParameters.add(LOGGER_PARAMETER, IdeaAntLogger2.class.getName());
        }
        if (!programParameters.getList().contains(INPUT_HANDLER_PARAMETER)) {
            programParameters.add(INPUT_HANDLER_PARAMETER, IdeaInputHandler.class.getName());
        }
        this.myProperties = (List)AntBuildFileImpl.ANT_PROPERTIES.get(container);
        this.myBuildFilePath = buildFile.getAbsolutePath();
        this.myCommandLine.setWorkingDirectory(buildFile.getParent());
    }

    public JavaParameters getCommandLine() {
        if (this.myDone) {
            return this.myCommandLine;
        }
        ParametersList programParameters = this.myCommandLine.getProgramParametersList();
        for (String property : this.myExpandedProperties) {
            if (property == null) continue;
            programParameters.add(property);
        }
        programParameters.add("-buildfile", this.myBuildFilePath);
        for (String target : this.myTargets) {
            if (target == null) continue;
            programParameters.add(target);
        }
        this.myDone = true;
        return this.myCommandLine;
    }

    public void addTargets(@NlsSafe String[] targets) {
        ContainerUtil.addAll(this.myTargets, (Object[])targets);
    }

    public void addTargets(Collection<@NlsSafe String> targets) {
        this.myTargets.addAll(targets);
    }

    @NlsSafe
    public String[] getTargets() {
        return ArrayUtilRt.toStringArray(this.myTargets);
    }
}

