/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateConfigurable;
import git4idea.update.GitUpdateInfoAsLog;
import git4idea.update.GitUpdateProcess;
import git4idea.update.GitUpdateSession;
import git4idea.update.HashRange;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateEnvironment
implements UpdateEnvironment {
    private final Project myProject;

    public GitUpdateEnvironment(@NotNull Project project) {
        if (project == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void fillGroups(UpdatedFiles updatedFiles) {
    }

    @NotNull
    public UpdateSession updateDirectories(FilePath @NotNull [] filePaths, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, @NotNull Ref<SequentialUpdatesContext> sequentialUpdatesContextRef) throws ProcessCanceledException {
        if (sequentialUpdatesContextRef == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(1);
        }
        if (filePaths == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(2);
        }
        UpdateSession updateSession = GitUpdateEnvironment.performUpdate(this.myProject, filePaths, updatedFiles, progressIndicator, GitVcsSettings.getInstance(this.myProject).getUpdateMethod(), null);
        if (updateSession == null) {
            GitUpdateEnvironment.$$$reportNull$$$0(3);
        }
        return updateSession;
    }

    public boolean validateOptions(Collection<FilePath> filePaths) {
        for (FilePath p : filePaths) {
            if (GitUtil.isUnderGit(p)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Configurable createConfigurable(Collection<FilePath> files) {
        return new GitUpdateConfigurable(GitVcsSettings.getInstance(this.myProject));
    }

    @RequiresEdt
    public boolean hasCustomNotification() {
        boolean keepLogUpToDate = PostponableLogRefresher.keepUpToDate();
        return Registry.is((String)"git.update.project.info.as.log") && keepLogUpToDate;
    }

    @ApiStatus.Internal
    public static UpdateSession performUpdate(Project project, FilePath[] filePaths, UpdatedFiles updatedFiles, ProgressIndicator progressIndicator, UpdateMethod updateMethod, Map<GitRepository, GitBranchPair> updateConfig) {
        GitRepositoryManager manager = GitRepositoryManager.getInstance(project);
        Set repositories = ContainerUtil.map2SetNotNull(Arrays.asList(filePaths), arg_0 -> ((GitRepositoryManager)manager).getRepositoryForFile(arg_0));
        GitUpdateProcess gitUpdateProcess = new GitUpdateProcess(project, progressIndicator, repositories, updatedFiles, updateConfig, true, true);
        boolean result2 = gitUpdateProcess.update(updateMethod).isSuccess();
        Map<GitRepository, HashRange> updatedRanges = gitUpdateProcess.getUpdatedRanges();
        GitUpdateInfoAsLog.NotificationData notificationData = updatedRanges != null ? new GitUpdateInfoAsLog(project, updatedRanges).calculateDataAndCreateLogTab() : null;
        return new GitUpdateSession(project, notificationData, result2, gitUpdateProcess.getSkippedRoots());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequentialUpdatesContextRef";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitUpdateEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitUpdateEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateDirectories";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

