/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.PlatformIcons;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesTreeComponent;
import git4idea.ui.branch.dashboard.BranchesTreeKt;
import git4idea.ui.branch.dashboard.NodeType;
import icons.DvcsImplIcons;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0002J\b\u0010\u001d\u001a\u00020\bH\u0002R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;", "Lcom/intellij/ide/dnd/aware/DnDAwareTree;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "doubleClickHandler", "Lkotlin/Function1;", "Lgit4idea/ui/branch/dashboard/BranchTreeNode;", "", "getDoubleClickHandler", "()Lkotlin/jvm/functions/Function1;", "setDoubleClickHandler", "(Lkotlin/jvm/functions/Function1;)V", "searchField", "Lcom/intellij/ui/SearchTextField;", "getSearchField", "()Lcom/intellij/ui/SearchTextField;", "setSearchField", "(Lcom/intellij/ui/SearchTextField;)V", "getSelectedBranches", "", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "getSelectedNodes", "Lkotlin/sequences/Sequence;", "getSelectedRemotes", "", "hasFocus", "", "initDnD", "installDoubleClickHandler", "BranchTreeCellRenderer", "intellij.vcs.git"})
public final class BranchesTreeComponent
extends DnDAwareTree {
    @NotNull
    private Function1<? super BranchTreeNode, Unit> doubleClickHandler;
    @Nullable
    private SearchTextField searchField;

    @NotNull
    public final Function1<BranchTreeNode, Unit> getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public final void setDoubleClickHandler(@NotNull Function1<? super BranchTreeNode, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.doubleClickHandler = function1;
    }

    @Nullable
    public final SearchTextField getSearchField() {
        return this.searchField;
    }

    public final void setSearchField(@Nullable SearchTextField searchTextField) {
        this.searchField = searchTextField;
    }

    public boolean hasFocus() {
        SearchTextField searchTextField;
        return super.hasFocus() || ((searchTextField = this.searchField) != null && (searchTextField = searchTextField.getTextEditor()) != null ? searchTextField.hasFocus() : false);
    }

    private final void installDoubleClickHandler() {
        new DoubleClickListener(this){
            final /* synthetic */ BranchesTreeComponent this$0;

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TreePath treePath = this.this$0.getClosestPathForLocation(e.getX(), e.getY());
                if (treePath == null) {
                    return false;
                }
                TreePath clickPath = treePath;
                TreePath selectionPath = this.this$0.getSelectionPath();
                if (selectionPath == null || Intrinsics.areEqual((Object)clickPath, (Object)selectionPath) ^ true) {
                    return false;
                }
                Object object = selectionPath.getLastPathComponent();
                if (!(object instanceof BranchTreeNode)) {
                    object = null;
                }
                BranchTreeNode branchTreeNode = (BranchTreeNode)object;
                if (branchTreeNode == null) {
                    return false;
                }
                BranchTreeNode node2 = branchTreeNode;
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)((Object)this.this$0)), (MouseEvent)e)) {
                    return false;
                }
                this.this$0.getDoubleClickHandler().invoke((Object)node2);
                return true;
            }
            {
                this.this$0 = this$0;
            }
        }.installOn((Component)((Object)this));
    }

    private final void initDnD() {
        if (!GraphicsEnvironment.isHeadless()) {
            this.setTransferHandler(BranchesTreeKt.access$getBRANCH_TREE_TRANSFER_HANDLER$p());
        }
    }

    @NotNull
    public final Set<BranchInfo> getSelectedBranches() {
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull(this.getSelectedNodes(), (Function1)getSelectedBranches.1.INSTANCE));
    }

    @NotNull
    public final Sequence<BranchTreeNode> getSelectedNodes() {
        Object[] objectArray = this.getSelectionPaths();
        if (objectArray == null) {
            return SequencesKt.emptySequence();
        }
        Object[] paths = objectArray;
        return SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])paths), (Function1)getSelectedNodes.1.INSTANCE), (Function1)getSelectedNodes.2.INSTANCE);
    }

    @NotNull
    public final Set<String> getSelectedRemotes() {
        Object[] objectArray = this.getSelectionPaths();
        if (objectArray == null) {
            return SetsKt.emptySet();
        }
        Object[] paths = objectArray;
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])paths), (Function1)getSelectedRemotes.1.INSTANCE), (Function1)getSelectedRemotes.2.INSTANCE), (Function1)getSelectedRemotes.3.INSTANCE), (Function1)getSelectedRemotes.4.INSTANCE));
    }

    public BranchesTreeComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.doubleClickHandler = doubleClickHandler.1.INSTANCE;
        this.putClientProperty(DnDAwareTree.AUTO_SELECT_ON_MOUSE_PRESSED, false);
        this.setCellRenderer((TreeCellRenderer)((Object)new BranchTreeCellRenderer(project)));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setOpaque(false);
        this.setHorizontalAutoScrollingEnabled(false);
        this.installDoubleClickHandler();
        SmartExpander.installOn((JTree)((JTree)((Object)this)));
        this.initDnD();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0014JB\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesTreeComponent$BranchTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "(Lgit4idea/ui/branch/dashboard/BranchesTreeComponent;Lcom/intellij/openapi/project/Project;)V", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "Lorg/jetbrains/annotations/NotNull;", "calcFocusedState", "", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "expanded", "leaf", "row", "", "hasFocus", "intellij.vcs.git"})
    private final class BranchTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final GitRepositoryManager repositoryManager;

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            boolean isGroupNode;
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            if (!(value instanceof BranchTreeNode)) {
                return;
            }
            BranchNodeDescriptor descriptor = ((BranchTreeNode)value).getNodeDescriptor();
            BranchInfo branchInfo = descriptor.getBranchInfo();
            boolean isBranchNode = descriptor.getType() == NodeType.BRANCH;
            boolean bl = isGroupNode = descriptor.getType() == NodeType.GROUP_NODE;
            this.setIcon(isBranchNode && branchInfo != null && branchInfo.isCurrent() && branchInfo.isFavorite() ? DvcsImplIcons.CurrentBranchFavoriteLabel : (isBranchNode && branchInfo != null && branchInfo.isCurrent() ? DvcsImplIcons.CurrentBranchLabel : (isBranchNode && branchInfo != null && branchInfo.isFavorite() ? AllIcons.Nodes.Favorite : (isBranchNode ? AllIcons.Vcs.BranchNode : (isGroupNode ? PlatformIcons.FOLDER_ICON : null)))));
            this.append(((BranchTreeNode)value).getTextRepresentation(), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            if (branchInfo != null && branchInfo.getRepositories().size() < this.repositoryManager.getRepositories().size()) {
                this.append(" (" + DvcsUtil.getShortNames((Collection)branchInfo.getRepositories()) + ')', SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        protected boolean calcFocusedState() {
            SearchTextField searchTextField;
            return super.calcFocusedState() || ((searchTextField = BranchesTreeComponent.this.getSearchField()) != null && (searchTextField = searchTextField.getTextEditor()) != null ? searchTextField.hasFocus() : false);
        }

        public BranchTreeCellRenderer(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
            this.repositoryManager = gitRepositoryManager;
        }
    }
}

