/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitStashDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GitStash
extends GitRepositoryAction {
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        if (project == null) {
            GitStash.$$$reportNull$$$0(0);
        }
        if (gitRoots == null) {
            GitStash.$$$reportNull$$$0(1);
        }
        if (defaultRoot == null) {
            GitStash.$$$reportNull$$$0(2);
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(GitBundle.message("stash.error.can.not.stash.changes.now", new Object[0]))) {
            return;
        }
        GitStashDialog d = new GitStashDialog(project, gitRoots, defaultRoot);
        if (!d.showAndGet()) {
            return;
        }
        GitStash.runStashInBackground(project, Collections.singleton(d.getGitRoot()), root -> d.handler());
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.message("stash.action.name", new Object[0]);
        if (string == null) {
            GitStash.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void runStashInBackground(final @NotNull Project project, final @NotNull Collection<VirtualFile> roots, final @NotNull Function<VirtualFile, GitLineHandler> createHandler) {
        if (project == null) {
            GitStash.$$$reportNull$$$0(4);
        }
        if (roots == null) {
            GitStash.$$$reportNull$$$0(5);
        }
        if (createHandler == null) {
            GitStash.$$$reportNull$$$0(6);
        }
        new Task.Backgroundable(project, GitBundle.message("stashing.progress.title", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try (AccessToken ignored = DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitBundle.message("stash.action.name", new Object[0]));){
                    ArrayList<VirtualFile> successfulRoots = new ArrayList<VirtualFile>();
                    LinkedHashMap<VirtualFile, @Nls String> failedRoots = new LinkedHashMap<VirtualFile, String>();
                    for (VirtualFile root : roots) {
                        GitCommandResult result2 = Git.getInstance().runCommand((GitLineHandler)createHandler.apply(root));
                        if (result2.success()) {
                            successfulRoots.add(root);
                            continue;
                        }
                        failedRoots.put(root, result2.getErrorOutputAsHtmlString());
                    }
                    if (!successfulRoots.isEmpty()) {
                        GitUtil.refreshVfsInRoots(successfulRoots);
                    }
                    if (!failedRoots.isEmpty()) {
                        String rootsList = StringUtil.join(failedRoots.keySet(), VirtualFile::getPresentableName, (String)",");
                        String errorTitle = GitBundle.message("stash.error", StringUtil.shortenTextWithEllipsis((String)rootsList, (int)100, (int)0));
                        String errorMessage = new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map(failedRoots.values(), s -> HtmlChunk.raw((String)s))).toString();
                        VcsNotifier.getInstance((Project)project).notifyError("git.stash.failed", errorTitle, errorMessage, true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitStash$1", "run"));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRoots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitStash";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitStash";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runStashInBackground";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

