/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fest.reflect.core.Reflection;
import org.fest.util.Preconditions;

class ProtectingTimerTask
extends TimerTask {
    private static final int CANCELED = 3;
    private static Logger logger = Logger.getLogger(ProtectingTimerTask.class.getCanonicalName());
    private final TimerTask task;

    ProtectingTimerTask(TimerTask task) {
        this.task = task;
    }

    @Override
    public void run() {
        if (this.isCanceled()) {
            this.cancel();
            return;
        }
        try {
            this.task.run();
        }
        catch (Throwable thrown) {
            this.handleException(thrown);
        }
    }

    private boolean isCanceled() {
        try {
            int state = (Integer)Preconditions.checkNotNull((Object)Reflection.field((String)"state").ofType(Integer.TYPE).in((Object)this.task).get());
            return state == 3;
        }
        catch (RuntimeException e) {
            this.handleException(e);
            return false;
        }
    }

    private void handleException(Throwable thrown) {
        logger.log(Level.WARNING, "Exception thrown by a TimerTask", thrown);
    }
}

