/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.util.Maps;
import org.fest.util.Sets;

class EventQueueMapping {
    final Map<Component, WeakReference<EventQueue>> queueMap = Maps.newWeakHashMap();

    EventQueueMapping() {
    }

    @RunsInCurrentThread
    void addQueueFor(@Nonnull Component c) {
        EventQueue queue = c.getToolkit().getSystemEventQueue();
        this.queueMap.put(c, new WeakReference<EventQueue>(queue));
    }

    @Nullable
    @RunsInCurrentThread
    EventQueue queueFor(@Nonnull Component c) {
        EventQueue queue = this.storedQueueFor(c);
        if (queue == null) {
            return c.getToolkit().getSystemEventQueue();
        }
        return queue;
    }

    @Nullable
    EventQueue storedQueueFor(@Nonnull Component c) {
        return this.queueFrom(this.queueMap.get(c));
    }

    @Nonnull
    Collection<EventQueue> eventQueues() {
        HashSet eventQueues = Sets.newHashSet();
        for (WeakReference<EventQueue> reference : this.queueMap.values()) {
            EventQueue queue = this.queueFrom(reference);
            if (queue == null) continue;
            eventQueues.add(queue);
        }
        return eventQueues;
    }

    @Nullable
    private EventQueue queueFrom(@Nullable WeakReference<EventQueue> reference) {
        if (reference == null) {
            return null;
        }
        return (EventQueue)reference.get();
    }
}

