/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.JComboBox;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.util.Arrays;
import org.fest.util.Lists;
import org.fest.util.Strings;

public class JComboBoxFormatter
extends ComponentFormatterTemplate {
    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        JComboBox comboBox = (JComboBox)c;
        String format = "%s[name=%s, selectedItem=%s, contents=%s, editable=%b, enabled=%b, visible=%b, showing=%b]";
        return String.format(format, comboBox.getClass().getName(), Strings.quote((String)comboBox.getName()), Strings.quote((Object)comboBox.getSelectedItem()), Arrays.format((Object)this.contentsOf(comboBox)), comboBox.isEditable(), comboBox.isEnabled(), comboBox.isVisible(), comboBox.isShowing());
    }

    @Nonnull
    @RunsInCurrentThread
    private Object[] contentsOf(@Nonnull JComboBox comboBox) {
        ArrayList contents = Lists.newArrayList();
        int count = comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            contents.add(comboBox.getItemAt(i));
        }
        return contents.toArray();
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JComboBox.class;
    }
}

