/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JTreeDriver;
import org.fest.swing.fixture.AbstractJPopupMenuInvokerFixture;
import org.fest.swing.fixture.EditableComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTreePathFixture;
import org.fest.swing.fixture.JTreeRowFixture;

public class JTreeFixture
extends AbstractJPopupMenuInvokerFixture<JTreeFixture, JTree, JTreeDriver>
implements EditableComponentFixture<JTreeFixture> {
    public JTreeFixture(@Nonnull Robot robot, @Nonnull JTree target) {
        super(JTreeFixture.class, robot, target);
    }

    public JTreeFixture(@Nonnull Robot robot, @Nullable String treeName) {
        super(JTreeFixture.class, robot, treeName, JTree.class);
    }

    @Override
    @Nonnull
    protected JTreeDriver createDriver(@Nonnull Robot robot) {
        return new JTreeDriver(robot);
    }

    @Nonnull
    public JTreeFixture clickRow(int row) {
        ((JTreeDriver)this.driver()).clickRow((JTree)this.target(), row);
        return this;
    }

    @Nonnull
    public JTreeFixture clickRow(int row, @Nonnull MouseButton button) {
        ((JTreeDriver)this.driver()).clickRow((JTree)this.target(), row, button);
        return this;
    }

    @Nonnull
    public JTreeFixture clickRow(int row, @Nonnull MouseClickInfo mouseClickInfo) {
        ((JTreeDriver)this.driver()).clickRow((JTree)this.target(), row, mouseClickInfo);
        return this;
    }

    @Nonnull
    public JTreeFixture clickPath(@Nonnull String path) {
        ((JTreeDriver)this.driver()).clickPath((JTree)this.target(), path);
        return this;
    }

    @Nonnull
    public JTreeFixture clickPath(@Nonnull String path, @Nonnull MouseButton button) {
        ((JTreeDriver)this.driver()).clickPath((JTree)this.target(), path, button);
        return this;
    }

    @Nonnull
    public JTreeFixture clickPath(@Nonnull String path, @Nonnull MouseClickInfo mouseClickInfo) {
        ((JTreeDriver)this.driver()).clickPath((JTree)this.target(), path, mouseClickInfo);
        return this;
    }

    @Nonnull
    public JTreeFixture doubleClickRow(int row) {
        ((JTreeDriver)this.driver()).doubleClickRow((JTree)this.target(), row);
        return this;
    }

    @Nonnull
    public JTreeFixture doubleClickPath(@Nonnull String path) {
        ((JTreeDriver)this.driver()).doubleClickPath((JTree)this.target(), path);
        return this;
    }

    @Nonnull
    public JTreeFixture rightClickRow(int row) {
        ((JTreeDriver)this.driver()).rightClickRow((JTree)this.target(), row);
        return this;
    }

    @Nonnull
    public JTreeFixture rightClickPath(@Nonnull String path) {
        ((JTreeDriver)this.driver()).rightClickPath((JTree)this.target(), path);
        return this;
    }

    @Nonnull
    public JTreeFixture drag(int row) {
        ((JTreeDriver)this.driver()).drag((JTree)this.target(), row);
        return this;
    }

    @Nonnull
    public JTreeFixture drop(int row) {
        ((JTreeDriver)this.driver()).drop((JTree)this.target(), row);
        return this;
    }

    @Nonnull
    public JTreeFixture drag(@Nonnull String path) {
        ((JTreeDriver)this.driver()).drag((JTree)this.target(), path);
        return this;
    }

    @Nonnull
    public JTreeFixture drop(@Nonnull String path) {
        ((JTreeDriver)this.driver()).drop((JTree)this.target(), path);
        return this;
    }

    @Nonnull
    public JTreeFixture selectRow(int row) {
        ((JTreeDriver)this.driver()).selectRow((JTree)this.target(), row);
        return this;
    }

    @Nonnull
    public JTreeFixture selectRows(int ... rows) {
        ((JTreeDriver)this.driver()).selectRows((JTree)this.target(), rows);
        return this;
    }

    @Nonnull
    public JTreeFixture selectPath(@Nonnull String path) {
        ((JTreeDriver)this.driver()).selectPath((JTree)this.target(), path);
        return this;
    }

    @Nonnull
    public JTreeFixture selectPaths(String ... paths) {
        ((JTreeDriver)this.driver()).selectPaths((JTree)this.target(), paths);
        return this;
    }

    @Nonnull
    public JTreeFixture toggleRow(int row) {
        ((JTreeDriver)this.driver()).toggleRow((JTree)this.target(), row);
        return this;
    }

    @Nonnull
    public JTreeFixture expandRow(int row) {
        ((JTreeDriver)this.driver()).expandRow((JTree)this.target(), row);
        return this;
    }

    @Nonnull
    public JTreeFixture collapseRow(int row) {
        ((JTreeDriver)this.driver()).collapseRow((JTree)this.target(), row);
        return this;
    }

    @Nonnull
    public JTreeFixture expandPath(@Nonnull String path) {
        ((JTreeDriver)this.driver()).expandPath((JTree)this.target(), path);
        return this;
    }

    @Nonnull
    public JTreeFixture collapsePath(@Nonnull String path) {
        ((JTreeDriver)this.driver()).collapsePath((JTree)this.target(), path);
        return this;
    }

    @Nonnull
    public JPopupMenuFixture showPopupMenuAt(int row) {
        JPopupMenu popupMenu = ((JTreeDriver)this.driver()).showPopupMenu((JTree)this.target(), row);
        return new JPopupMenuFixture(this.robot(), popupMenu);
    }

    @Nonnull
    public JPopupMenuFixture showPopupMenuAt(@Nonnull String path) {
        JPopupMenu popupMenu = ((JTreeDriver)this.driver()).showPopupMenu((JTree)this.target(), path);
        return new JPopupMenuFixture(this.robot(), popupMenu);
    }

    @Override
    @Nonnull
    public JTreeFixture requireEditable() {
        ((JTreeDriver)this.driver()).requireEditable((JTree)this.target());
        return this;
    }

    @Override
    @Nonnull
    public JTreeFixture requireNotEditable() {
        ((JTreeDriver)this.driver()).requireNotEditable((JTree)this.target());
        return this;
    }

    @Nonnull
    public JTreeFixture requireSelection(int ... rows) {
        ((JTreeDriver)this.driver()).requireSelection((JTree)this.target(), rows);
        return this;
    }

    @Nonnull
    public JTreeFixture requireSelection(String ... paths) {
        ((JTreeDriver)this.driver()).requireSelection((JTree)this.target(), paths);
        return this;
    }

    @Nonnull
    public JTreeFixture requireNoSelection() {
        ((JTreeDriver)this.driver()).requireNoSelection((JTree)this.target());
        return this;
    }

    public String separator() {
        return ((JTreeDriver)this.driver()).separator();
    }

    @Nonnull
    public JTreeFixture replaceSeparator(@Nonnull String separator) {
        ((JTreeDriver)this.driver()).replaceSeparator(separator);
        return this;
    }

    @Nonnull
    public JTreeFixture replaceCellReader(@Nonnull JTreeCellReader cellReader) {
        ((JTreeDriver)this.driver()).replaceCellReader(cellReader);
        return this;
    }

    @Nonnull
    public JTreeRowFixture node(int row) {
        ((JTreeDriver)this.driver()).checkRowInBounds((JTree)this.target(), row);
        return new JTreeRowFixture(this, row);
    }

    @Nonnull
    public JTreePathFixture node(@Nonnull String path) {
        ((JTreeDriver)this.driver()).checkPathExists((JTree)this.target(), path);
        return new JTreePathFixture(this, path);
    }

    @Nullable
    public String valueAt(int row) {
        return ((JTreeDriver)this.driver()).nodeValue((JTree)this.target(), row);
    }

    @Nullable
    public String valueAt(@Nonnull String path) {
        return ((JTreeDriver)this.driver()).nodeValue((JTree)this.target(), path);
    }
}

