/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.util.Pair;
import org.fest.util.Preconditions;

final class PointAndParentForScrollingJTextFieldQuery {
    @Nonnull
    @RunsInCurrentThread
    static Pair<Point, Container> pointAndParentForScrolling(@Nonnull JTextField textField) {
        Container parent;
        Point origin = new Point(textField.getX(), textField.getY());
        for (parent = textField.getParent(); parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane); parent = parent.getParent()) {
            origin = PointAndParentForScrollingJTextFieldQuery.addRectangleToPoint((Rectangle)Preconditions.checkNotNull((Object)parent.getBounds()), origin);
        }
        return Pair.of(origin, parent);
    }

    @Nonnull
    private static Point addRectangleToPoint(@Nonnull Rectangle r, @Nonnull Point p) {
        Point newPoint = new Point(p);
        newPoint.x += r.x;
        newPoint.y += r.y;
        return newPoint;
    }

    private PointAndParentForScrollingJTextFieldQuery() {
    }
}

