/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Frame;
import java.awt.Window;
import javax.annotation.Nonnull;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.fest.swing.annotation.RunsInCurrentThread;

final class JToolBarIsFloatingQuery {
    @RunsInCurrentThread
    static boolean isJToolBarFloating(@Nonnull JToolBar toolBar) {
        ToolBarUI ui = toolBar.getUI();
        if (ui instanceof BasicToolBarUI) {
            return ((BasicToolBarUI)ui).isFloating();
        }
        Window w = SwingUtilities.getWindowAncestor(toolBar);
        return !(w instanceof Frame) && toolBar.getParent().getComponentCount() == 1;
    }

    private JToolBarIsFloatingQuery() {
    }
}

